/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonatype.spice.zapper.IOSource;
import org.sonatype.spice.zapper.Path;
import org.sonatype.spice.zapper.codec.Codec;
import org.sonatype.spice.zapper.hash.Hash;
import org.sonatype.spice.zapper.internal.AbstractIdentified;
import org.sonatype.spice.zapper.internal.Check;
import org.sonatype.spice.zapper.internal.Payload;
import org.sonatype.spice.zapper.internal.Segment;
import org.sonatype.spice.zapper.internal.SegmentIdentifier;
import org.sonatype.spice.zapper.internal.TransferIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentPayload
extends AbstractIdentified<SegmentIdentifier>
implements Payload {
    private final TransferIdentifier transferIdentifier;
    private final Path path;
    private final Segment segment;
    private final IOSource ioSource;
    private final Hash hash;
    private final List<Codec> codecs;

    public SegmentPayload(TransferIdentifier transferIdentifier, Path path, Segment segment, IOSource ioSource, Hash hash, List<Codec> codecs) throws IOException {
        super(Check.notNull(segment, Segment.class).getIdentifier());
        this.transferIdentifier = Check.notNull(transferIdentifier, TransferIdentifier.class);
        this.path = Check.notNull(path, Path.class);
        this.segment = segment;
        this.ioSource = Check.notNull(ioSource, IOSource.class);
        this.hash = Check.notNull(hash, Hash.class);
        ArrayList<Codec> cds = new ArrayList<Codec>();
        if (codecs != null) {
            cds.addAll(codecs);
        }
        this.codecs = Collections.unmodifiableList(cds);
    }

    public Segment getSegment() {
        return this.segment;
    }

    @Override
    public TransferIdentifier getTransferIdentifier() {
        return this.transferIdentifier;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public long getLength() {
        return this.segment.getLength();
    }

    @Override
    public InputStream getContent() throws IOException {
        return this.ioSource.readSegment((Path)this.segment.getZFile().getIdentifier(), this.segment);
    }

    @Override
    public Hash getHash() {
        return this.hash;
    }

    @Override
    public List<Codec> getCodecs() {
        return this.codecs;
    }

    protected IOSource getIoSource() {
        return this.ioSource;
    }
}

