/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.impl.CallIdHeaderImpl;
import io.pkts.packet.sip.impl.PreConditions;

public interface CallIdHeader
extends SipHeader {
    public static final Buffer NAME = Buffers.wrap((String)"Call-ID");
    public static final Buffer COMPACT_NAME = Buffers.wrap((String)"i");

    public Buffer getCallId();

    @Override
    public CallIdHeader clone();

    @Override
    default public boolean isCallIdHeader() {
        return true;
    }

    @Override
    default public CallIdHeader toCallIdHeader() {
        return this;
    }

    public static CallIdHeader frame(Buffer buffer) {
        PreConditions.assertNotEmpty(buffer, "The value of the Call-ID cannot be null or empty");
        return new CallIdHeaderImpl(buffer);
    }

    public static CallIdHeader frameCompact(Buffer buffer) throws SipParseException {
        PreConditions.assertNotEmpty(buffer, "The value of the Call-ID cannot be null or empty");
        return new CallIdHeaderImpl(true, buffer);
    }

    public static CallIdHeader create() {
        return new CallIdHeaderImpl();
    }
}

