/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.Parameters;
import io.pkts.packet.sip.header.impl.ParametersSupport;
import io.pkts.packet.sip.header.impl.SipHeaderImpl;
import io.pkts.packet.sip.impl.PreConditions;
import java.util.function.Supplier;

public abstract class ParametersImpl
extends SipHeaderImpl
implements Parameters {
    private final ParametersSupport support;
    private final Buffer params;

    protected ParametersImpl(Buffer name, Buffer value, Buffer params) {
        super(name, value);
        this.params = params != null ? params.slice() : Buffers.EMPTY_BUFFER;
        this.support = new ParametersSupport(params);
    }

    @Override
    public Buffer getParameter(Buffer name) throws SipParseException {
        return this.support.getParameter(name);
    }

    @Override
    public Buffer getParameter(String name) throws SipParseException {
        return this.support.getParameter(name);
    }

    @Override
    public void setParameter(Buffer name, Buffer value) throws SipParseException, IllegalArgumentException {
        this.support.setParameter(name, value);
    }

    @Override
    public void setParameter(Buffer name, Supplier<Buffer> value) throws SipParseException, IllegalArgumentException {
        PreConditions.assertNotNull(value);
        this.support.setParameter(name, value.get());
    }

    protected Buffer getRawParams() {
        return this.params.slice();
    }
}

