/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.filter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.maven.plugins.assembly.filter.ContainerDescriptorHandler;
import org.apache.maven.shared.utils.ReaderFactory;
import org.apache.maven.shared.utils.WriterFactory;
import org.apache.maven.shared.utils.xml.XmlStreamWriter;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=ContainerDescriptorHandler.class, hint="plexus", instantiationStrategy="per-lookup")
public class ComponentsXmlArchiverFileFilter
implements ContainerDescriptorHandler {
    public static final String COMPONENTS_XML_PATH = "META-INF/plexus/components.xml";
    Map<String, Xpp3Dom> components;
    private boolean excludeOverride = false;

    void addComponentsXml(Reader componentsReader) throws XmlPullParserException, IOException {
        Xpp3Dom newDom = Xpp3DomBuilder.build((Reader)componentsReader);
        if (newDom != null) {
            newDom = newDom.getChild("components");
        }
        if (newDom != null) {
            Xpp3Dom[] children;
            for (Xpp3Dom component : children = newDom.getChildren()) {
                if (this.components == null) {
                    this.components = new LinkedHashMap<String, Xpp3Dom>();
                }
                String role = component.getChild("role").getValue();
                Xpp3Dom child = component.getChild("role-hint");
                String roleHint = child != null ? child.getValue() : "";
                String key = role + roleHint;
                if (this.components.containsKey(key)) continue;
                this.components.put(key, component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToArchive(Archiver archiver) throws IOException {
        block3: {
            if (this.components == null) break block3;
            File f = File.createTempFile("maven-assembly-plugin", "tmp");
            f.deleteOnExit();
            XmlStreamWriter fileWriter = null;
            try {
                fileWriter = WriterFactory.newXmlWriter((OutputStream)new FileOutputStream(f));
                Xpp3Dom dom = new Xpp3Dom("component-set");
                Xpp3Dom componentDom = new Xpp3Dom("components");
                dom.addChild(componentDom);
                for (Xpp3Dom component : this.components.values()) {
                    componentDom.addChild(component);
                }
                Xpp3DomWriter.write((Writer)fileWriter, (Xpp3Dom)dom);
                fileWriter.close();
                fileWriter = null;
            }
            catch (Throwable throwable) {
                IOUtil.close(fileWriter);
                throw throwable;
            }
            IOUtil.close((Writer)fileWriter);
            this.excludeOverride = true;
            archiver.addFile(f, COMPONENTS_XML_PATH);
            this.excludeOverride = false;
        }
    }

    public void finalizeArchiveCreation(Archiver archiver) {
        ResourceIterator it = archiver.getResources();
        while (it.hasNext()) {
            it.next();
        }
        try {
            this.addToArchive(archiver);
        }
        catch (IOException e) {
            throw new ArchiverException("Error finalizing component-set for archive. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<String> getVirtualFiles() {
        if (this.components != null && !this.components.isEmpty()) {
            return Collections.singletonList(COMPONENTS_XML_PATH);
        }
        return null;
    }

    public boolean isSelected(@Nonnull FileInfo fileInfo) throws IOException {
        block6: {
            block7: {
                if (!fileInfo.isFile()) break block6;
                if (this.excludeOverride) {
                    return true;
                }
                String entry = fileInfo.getName().replace('\\', '/');
                if (entry.startsWith("/")) {
                    entry = entry.substring(1);
                }
                if (!COMPONENTS_XML_PATH.equals(entry)) break block7;
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(ReaderFactory.newXmlReader((InputStream)fileInfo.getContents()));
                    this.addComponentsXml(reader);
                    ((Reader)reader).close();
                    reader = null;
                }
                catch (XmlPullParserException e) {
                    try {
                        IOException error = new IOException("Error finalizing component-set for archive. Reason: " + e.getMessage(), e);
                        throw error;
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(reader);
                        throw throwable;
                    }
                }
                IOUtil.close((Reader)reader);
                return false;
            }
            return true;
        }
        return true;
    }

    public void finalizeArchiveExtraction(UnArchiver unarchiver) {
    }
}

