/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Deque;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.DurationKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\u0003H\u0007R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/utils/RateLimit;", "", "defaultMinInterval", "Ljava/time/Duration;", "maxRequests", "", "interval", "clock", "Ljava/time/Clock;", "(Ljava/time/Duration;ILjava/time/Duration;Ljava/time/Clock;)V", "requests", "Ljava/util/Deque;", "Ljava/time/Instant;", "accept", "", "now", "minInterval", "jitsi-utils"})
public final class RateLimit {
    @NotNull
    private final Duration defaultMinInterval;
    private final int maxRequests;
    @NotNull
    private final Duration interval;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Deque<Instant> requests;

    public RateLimit(@NotNull Duration defaultMinInterval, int maxRequests, @NotNull Duration interval, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)defaultMinInterval, (String)"defaultMinInterval");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.defaultMinInterval = defaultMinInterval;
        this.maxRequests = maxRequests;
        this.interval = interval;
        this.clock = clock;
        this.requests = new LinkedList();
    }

    public /* synthetic */ RateLimit(Duration duration, int n, Duration duration2, Clock clock, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            duration = DurationKt.getSecs(10);
        }
        if ((n2 & 2) != 0) {
            n = 3;
        }
        if ((n2 & 4) != 0) {
            duration2 = DurationKt.getSecs(60);
        }
        if ((n2 & 8) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(duration, n, duration2, clock);
    }

    @JvmOverloads
    public final boolean accept(@NotNull Instant now, @NotNull Duration minInterval) {
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        Intrinsics.checkNotNullParameter((Object)minInterval, (String)"minInterval");
        Instant previousRequest = this.requests.peekLast();
        if (previousRequest == null) {
            this.requests.add(now);
            return true;
        }
        if (Duration.between(previousRequest, now).compareTo(minInterval) < 0) {
            return false;
        }
        this.requests.removeIf(arg_0 -> RateLimit.accept$lambda$0((Function1)new Function1<Instant, Boolean>(now, this){
            final /* synthetic */ Instant $now;
            final /* synthetic */ RateLimit this$0;
            {
                this.$now = $now;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Instant it) {
                return Duration.between(it, this.$now).compareTo(RateLimit.access$getInterval$p(this.this$0)) > 0;
            }
        }, arg_0));
        if (this.requests.size() >= this.maxRequests) {
            return false;
        }
        this.requests.add(now);
        return true;
    }

    public static /* synthetic */ boolean accept$default(RateLimit rateLimit, Instant instant, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            Instant instant2 = rateLimit.clock.instant();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"instant(...)");
            instant = instant2;
        }
        if ((n & 2) != 0) {
            duration = rateLimit.defaultMinInterval;
        }
        return rateLimit.accept(instant, duration);
    }

    @JvmOverloads
    public final boolean accept(@NotNull Instant now) {
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        return RateLimit.accept$default(this, now, null, 2, null);
    }

    @JvmOverloads
    public final boolean accept() {
        return RateLimit.accept$default(this, null, null, 3, null);
    }

    private static final boolean accept$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public RateLimit() {
        this(null, 0, null, null, 15, null);
    }

    public static final /* synthetic */ Duration access$getInterval$p(RateLimit $this) {
        return $this.interval;
    }
}

