<?php

namespace OpenStack\Networking\v2\Extensions\Layer3;

/**
 * @deprecated Use Networking\v2\Params instead
 *
 * @internal
 */
class Params extends \OpenStack\Networking\v2\Params
{
    public function tenantIdJson(): array
    {
        return [
            'type'        => self::STRING_TYPE,
            'description' => 'The UUID of the tenant. Only administrative users can specify a tenant UUID other than their own.',
            'sentAs'      => 'tenant_id',
        ];
    }

    public function floatingNetworkIdJson(): array
    {
        return [
            'type'        => self::STRING_TYPE,
            'description' => 'The UUID of the network associated with the floating IP.',
            'sentAs'      => 'floating_network_id',
            'required'    => true,
        ];
    }

    public function fixedIpAddressJson(): array
    {
        return [
            'type'        => self::STRING_TYPE,
            'description' => 'The fixed IP address that is associated with the floating IP. To associate the floating IP with a fixed IP at creation time, you must specify the identifier of the internal port. If an internal port has multiple associated IP addresses, the service chooses the first IP address unless you explicitly define a fixed IP address in the fixed_ip_address parameter.',
            'sentAs'      => 'fixed_ip_address',
        ];
    }

    public function floatingIpAddressJson(): array
    {
        return [
            'type'        => self::STRING_TYPE,
            'description' => 'The floating IP address.',
            'sentAs'      => 'floating_ip_address',
        ];
    }

    public function portIdJson(): array
    {
        return [
            'type'        => self::STRING_TYPE,
            'description' => 'The UUID of the port.',
            'sentAs'      => 'port_id',
        ];
    }

    public function enableSnatJson(): array
    {
        return [
            'type'        => self::BOOL_TYPE,
            'description' => 'Enable Source NAT (SNAT) attribute, a part of ext-gw-mode extension. When a gateway is attached to a router using an L3 extension, Network Address Translation (NAT) is enabled for traffic generated by subnets attached to the router.',
            'location'    => self::JSON,
            'sentAs'      => 'enable_snat',
        ];
    }

    public function ipJson(): array
    {
        return [
            'type' => self::STRING_TYPE,
        ];
    }

    public function externalFixedIpsJson(): array
    {
        return [
            'type'     => self::ARRAY_TYPE,
            'location' => self::JSON,
            'sentAs'   => 'external_fixed_ips',
            'items'    => [
                'type'       => self::OBJECT_TYPE,
                'properties' => [
                    'subnetId' => $this->subnetId(),
                    'ip'       => $this->ipJson(),
                ],
            ],
        ];
    }

    public function externalGatewayInfo(): array
    {
        return [
            'type'       => self::OBJECT_TYPE,
            'sentAs'     => 'external_gateway_info',
            'properties' => [
                'networkId'  => $this->networkId(),
                'enableSnat' => $this->enableSnatJson(),
                'fixedIps'   => $this->externalFixedIpsJson(),
            ],
        ];
    }

    public function distributedJson(): array
    {
        return [
            'type'        => self::BOOL_TYPE,
            'location'    => self::JSON,
            'description' => 'If true, indicates a distributed router.',
        ];
    }

    public function haJson(): array
    {
        return [
            'type'        => self::BOOL_TYPE,
            'location'    => self::JSON,
            'description' => 'If true, indicates a highly-available router.',
        ];
    }
}
