/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.util;

import com.android.tools.smali.dexlib2.AccessFlags;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedMethod;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedMethodImplementation;
import com.android.tools.smali.dexlib2.dexbacked.DexBuffer;
import com.android.tools.smali.dexlib2.dexbacked.DexReader;
import com.android.tools.smali.dexlib2.dexbacked.util.ParameterIterator;
import com.android.tools.smali.dexlib2.dexbacked.util.VariableSizeIterator;
import com.android.tools.smali.dexlib2.dexbacked.util.VariableSizeLookaheadIterator;
import com.android.tools.smali.dexlib2.iface.debug.DebugItem;
import com.android.tools.smali.dexlib2.iface.debug.EndLocal;
import com.android.tools.smali.dexlib2.iface.debug.LocalInfo;
import com.android.tools.smali.dexlib2.immutable.debug.ImmutableEndLocal;
import com.android.tools.smali.dexlib2.immutable.debug.ImmutableEpilogueBegin;
import com.android.tools.smali.dexlib2.immutable.debug.ImmutableLineNumber;
import com.android.tools.smali.dexlib2.immutable.debug.ImmutablePrologueEnd;
import com.android.tools.smali.dexlib2.immutable.debug.ImmutableRestartLocal;
import com.android.tools.smali.dexlib2.immutable.debug.ImmutableSetSourceFile;
import com.android.tools.smali.dexlib2.immutable.debug.ImmutableStartLocal;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;

public abstract class DebugInfo
implements Iterable<DebugItem> {
    public abstract Iterator<String> getParameterNames(DexReader var1);

    public static DebugInfo newOrEmpty(DexBackedDexFile dexFile, int debugInfoOffset, DexBackedMethodImplementation methodImpl) {
        if (debugInfoOffset == 0) {
            return EmptyDebugInfo.INSTANCE;
        }
        return new DebugInfoImpl(dexFile, debugInfoOffset, methodImpl);
    }

    private static class DebugInfoImpl
    extends DebugInfo {
        public final DexBackedDexFile dexFile;
        private final int debugInfoOffset;
        private final DexBackedMethodImplementation methodImpl;
        private static final LocalInfo EMPTY_LOCAL_INFO = new LocalInfo(){

            @Override
            public String getName() {
                return null;
            }

            @Override
            public String getType() {
                return null;
            }

            @Override
            public String getSignature() {
                return null;
            }
        };

        public DebugInfoImpl(DexBackedDexFile dexFile, int debugInfoOffset, DexBackedMethodImplementation methodImpl) {
            this.dexFile = dexFile;
            this.debugInfoOffset = debugInfoOffset;
            this.methodImpl = methodImpl;
        }

        @Override
        public Iterator<DebugItem> iterator() {
            DexReader<? extends DexBuffer> reader = this.dexFile.getDataBuffer().readerAt(this.debugInfoOffset);
            final int lineNumberStart = reader.readBigUleb128();
            int registerCount = this.methodImpl.getRegisterCount();
            final int lastInstructionAddress = this.methodImpl.getInstructionsSize() - Iterators.getLast(this.methodImpl.getInstructions().iterator()).getCodeUnits();
            Object[] locals = new LocalInfo[registerCount];
            Arrays.fill(locals, EMPTY_LOCAL_INFO);
            DexBackedMethod method = this.methodImpl.method;
            ParameterIterator parameterIterator = new ParameterIterator(method.getParameterTypes(), method.getParameterAnnotations(), this.getParameterNames(reader));
            int parameterIndex = 0;
            if (!AccessFlags.STATIC.isSet(this.methodImpl.method.getAccessFlags())) {
                locals[parameterIndex++] = new LocalInfo(){

                    @Override
                    public String getName() {
                        return "this";
                    }

                    @Override
                    public String getType() {
                        return ((DebugInfoImpl)this).methodImpl.method.getDefiningClass();
                    }

                    @Override
                    public String getSignature() {
                        return null;
                    }
                };
            }
            while (parameterIterator.hasNext()) {
                locals[parameterIndex++] = (LocalInfo)parameterIterator.next();
            }
            if (parameterIndex < registerCount) {
                Object currentLocal;
                String type;
                int localIndex = registerCount - 1;
                while (--parameterIndex > -1 && ((type = (currentLocal = locals[parameterIndex]).getType()) == null || !type.equals("J") && !type.equals("D") || --localIndex != parameterIndex)) {
                    locals[localIndex] = currentLocal;
                    locals[parameterIndex] = EMPTY_LOCAL_INFO;
                    --localIndex;
                }
            }
            return new VariableSizeLookaheadIterator<DebugItem>(this.dexFile.getDataBuffer(), reader.getOffset(), (LocalInfo[])locals){
                private int codeAddress;
                private int lineNumber;
                final /* synthetic */ LocalInfo[] val$locals;
                {
                    this.val$locals = localInfoArray;
                    super(buffer, offset);
                    this.codeAddress = 0;
                    this.lineNumber = lineNumberStart;
                }

                @Override
                protected DebugItem readNextItem(DexReader reader) {
                    block12: while (this.codeAddress <= lastInstructionAddress) {
                        int next = reader.readUbyte();
                        switch (next) {
                            case 0: {
                                return (DebugItem)this.endOfData();
                            }
                            case 1: {
                                int addressDiff = reader.readSmallUleb128();
                                this.codeAddress += addressDiff;
                                continue block12;
                            }
                            case 2: {
                                int lineDiff = reader.readSleb128();
                                this.lineNumber += lineDiff;
                                continue block12;
                            }
                            case 3: {
                                int register = reader.readSmallUleb128();
                                String name = dexFile.getStringSection().getOptional(reader.readSmallUleb128() - 1);
                                String type = dexFile.getTypeSection().getOptional(reader.readSmallUleb128() - 1);
                                ImmutableStartLocal startLocal = new ImmutableStartLocal(this.codeAddress, register, name, type, null);
                                if (register >= 0 && register < this.val$locals.length) {
                                    this.val$locals[register] = startLocal;
                                }
                                return startLocal;
                            }
                            case 4: {
                                int register = reader.readSmallUleb128();
                                String name = dexFile.getStringSection().getOptional(reader.readSmallUleb128() - 1);
                                String type = dexFile.getTypeSection().getOptional(reader.readSmallUleb128() - 1);
                                String signature = dexFile.getStringSection().getOptional(reader.readSmallUleb128() - 1);
                                ImmutableStartLocal startLocal = new ImmutableStartLocal(this.codeAddress, register, name, type, signature);
                                if (register >= 0 && register < this.val$locals.length) {
                                    this.val$locals[register] = startLocal;
                                }
                                return startLocal;
                            }
                            case 5: {
                                LocalInfo localInfo;
                                int register = reader.readSmallUleb128();
                                boolean replaceLocalInTable = true;
                                if (register >= 0 && register < this.val$locals.length) {
                                    localInfo = this.val$locals[register];
                                } else {
                                    localInfo = EMPTY_LOCAL_INFO;
                                    replaceLocalInTable = false;
                                }
                                if (localInfo instanceof EndLocal) {
                                    localInfo = EMPTY_LOCAL_INFO;
                                    replaceLocalInTable = false;
                                }
                                ImmutableEndLocal endLocal = new ImmutableEndLocal(this.codeAddress, register, localInfo.getName(), localInfo.getType(), localInfo.getSignature());
                                if (replaceLocalInTable) {
                                    this.val$locals[register] = endLocal;
                                }
                                return endLocal;
                            }
                            case 6: {
                                int register = reader.readSmallUleb128();
                                LocalInfo localInfo = register >= 0 && register < this.val$locals.length ? this.val$locals[register] : EMPTY_LOCAL_INFO;
                                ImmutableRestartLocal restartLocal = new ImmutableRestartLocal(this.codeAddress, register, localInfo.getName(), localInfo.getType(), localInfo.getSignature());
                                if (register >= 0 && register < this.val$locals.length) {
                                    this.val$locals[register] = restartLocal;
                                }
                                return restartLocal;
                            }
                            case 7: {
                                return new ImmutablePrologueEnd(this.codeAddress);
                            }
                            case 8: {
                                return new ImmutableEpilogueBegin(this.codeAddress);
                            }
                            case 9: {
                                String sourceFile = dexFile.getStringSection().getOptional(reader.readSmallUleb128() - 1);
                                return new ImmutableSetSourceFile(this.codeAddress, sourceFile);
                            }
                        }
                        int adjusted = next - 10;
                        this.codeAddress += adjusted / 15;
                        this.lineNumber += adjusted % 15 - 4;
                        if (this.codeAddress > lastInstructionAddress) {
                            return (DebugItem)this.endOfData();
                        }
                        return new ImmutableLineNumber(this.codeAddress, this.lineNumber);
                    }
                    return (DebugItem)this.endOfData();
                }
            };
        }

        public VariableSizeIterator<String> getParameterNames(DexReader reader) {
            if (reader == null) {
                reader = this.dexFile.getDataBuffer().readerAt(this.debugInfoOffset);
                reader.skipUleb128();
            }
            int parameterNameCount = reader.readSmallUleb128();
            return new VariableSizeIterator<String>(reader, parameterNameCount){

                @Override
                protected String readNextItem(DexReader reader, int index) {
                    return dexFile.getStringSection().getOptional(reader.readSmallUleb128() - 1);
                }
            };
        }
    }

    private static class EmptyDebugInfo
    extends DebugInfo {
        public static final EmptyDebugInfo INSTANCE = new EmptyDebugInfo();

        private EmptyDebugInfo() {
        }

        @Override
        public Iterator<DebugItem> iterator() {
            return ImmutableSet.of().iterator();
        }

        @Override
        public Iterator<String> getParameterNames(DexReader reader) {
            return ImmutableSet.of().iterator();
        }
    }
}

