/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.i18n;

import java.util.MissingResourceException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.i18n.GlobalMessages;
import org.pentaho.di.i18n.MessageHandler;
import org.pentaho.di.laf.BasePropertyHandler;

public class LAFMessageHandler
extends GlobalMessages {
    private static String replace = "org.pentaho.di";
    private static String replaceWith = null;
    private static int offset = -1;
    private static String replaceSysBundle = null;

    public LAFMessageHandler() {
        this.reinit();
    }

    public static synchronized MessageHandler getInstance() {
        if (GMinstance == null) {
            GMinstance = new LAFMessageHandler();
        }
        return GMinstance;
    }

    protected void reinit() {
        replaceWith = BasePropertyHandler.getProperty("LAFpackage");
        replaceSysBundle = this.replacePackage(SYSTEM_BUNDLE_PACKAGE);
        offset = -1;
    }

    private String replacePackage(String packageName) {
        if (offset < 0 && (offset = packageName.indexOf(replace)) >= 0) {
            offset = replace.length();
        }
        return new String(replaceWith + packageName.substring(offset));
    }

    private String internalCalc(String packageName, String global, String key, Object[] parameters) {
        String string = null;
        try {
            string = this.findString(packageName, langChoice.getDefaultLocale(), key, parameters);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (string != null) {
            return string;
        }
        try {
            string = this.findString(global, langChoice.getDefaultLocale(), key, parameters);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (string != null) {
            return string;
        }
        try {
            string = this.findString(packageName, langChoice.getFailoverLocale(), key, parameters);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (string != null) {
            return string;
        }
        try {
            string = this.findString(global, langChoice.getFailoverLocale(), key, parameters);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        return string;
    }

    protected String calculateString(String packageName, String key, Object[] parameters) {
        String string = null;
        if (replaceWith != null && (string = this.internalCalc(this.replacePackage(packageName), replaceSysBundle, key, parameters)) != null) {
            return string;
        }
        string = this.internalCalc(packageName, SYSTEM_BUNDLE_PACKAGE, key, parameters);
        if (string != null) {
            return string;
        }
        string = "!" + key + "!";
        if (LogWriter.getInstance().isDetailed()) {
            String message = "Message not found in the preferred and failover locale: key=[" + key + "], package=" + packageName;
            LogWriter.getInstance().logDetailed("i18n", Const.getStackTracker(new KettleException(message)), new Object[0]);
        }
        return string;
    }

    static {
        replaceWith = BasePropertyHandler.getProperty("LAFpackage");
    }
}

