/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink;

import com.almworks.tracklink.ModelCache;
import com.almworks.tracklink.codelinks.CodeLinkType;
import com.intellij.psi.search.IndexPatternProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PatternIndexer
implements IndexPatternProvider,
PropertyChangeListener {
    private final List<PropertyChangeListener> myListeners = new ArrayList<PropertyChangeListener>();

    public PatternIndexer() {
        ModelCache.getInstance().registerPatternIndexer(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        PropertyChangeListener[] listenersArr;
        for (PropertyChangeListener propertyChangeListener : listenersArr = this.myListeners.toArray(new PropertyChangeListener[this.myListeners.size()])) {
            propertyChangeListener.propertyChange(evt);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public CodeLinkType[] getIndexPatterns() {
        CodeLinkType[] codeLinkTypeArray = ModelCache.getInstance().getReferenceTypes();
        if (codeLinkTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/PatternIndexer.getIndexPatterns must not return null");
        }
        return codeLinkTypeArray;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.myListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.myListeners.remove(listener);
    }

    public void dispatchPendingEvent(PropertyChangeListener listener) {
    }
}

