/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.LocalVar;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.stmt.BaseSwitchStmt;
import com.googlecode.dex2jar.ir.stmt.JumpStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.ts.Transformer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CleanLabel
implements Transformer {
    @Override
    public void transform(IrMethod irMethod) {
        HashSet<LabelStmt> uselabels = new HashSet<LabelStmt>();
        this.addTrap(irMethod.traps, uselabels);
        this.addVars(irMethod.vars, uselabels);
        this.addStmt(irMethod.stmts, uselabels);
        this.rmUnused(irMethod.stmts, uselabels);
    }

    private void addVars(List<LocalVar> vars, Set<LabelStmt> uselabels) {
        if (vars != null) {
            for (LocalVar var : vars) {
                uselabels.add(var.start);
                uselabels.add(var.end);
            }
        }
    }

    private void rmUnused(StmtList stmts, Set<LabelStmt> uselabels) {
        Stmt p = stmts.getFirst();
        while (p != null) {
            if (p.st == Stmt.ST.LABEL && !uselabels.contains(p)) {
                Stmt q = p.getNext();
                stmts.remove(p);
                p = q;
                continue;
            }
            p = p.getNext();
        }
    }

    private void addStmt(StmtList stmts, Set<LabelStmt> labels) {
        Stmt p = stmts.getFirst();
        while (p != null) {
            if (p instanceof JumpStmt) {
                labels.add(((JumpStmt)((Object)p)).getTarget());
            } else if (p instanceof BaseSwitchStmt) {
                BaseSwitchStmt stmt = (BaseSwitchStmt)p;
                labels.add(stmt.defaultTarget);
                LabelStmt[] labelStmtArray = stmt.targets;
                int n = stmt.targets.length;
                int n2 = 0;
                while (n2 < n) {
                    LabelStmt t = labelStmtArray[n2];
                    labels.add(t);
                    ++n2;
                }
            }
            p = p.getNext();
        }
    }

    private void addTrap(List<Trap> traps, Set<LabelStmt> labels) {
        if (traps != null) {
            for (Trap trap : traps) {
                labels.add(trap.start);
                labels.add(trap.end);
                LabelStmt[] labelStmtArray = trap.handlers;
                int n = trap.handlers.length;
                int n2 = 0;
                while (n2 < n) {
                    LabelStmt h = labelStmtArray[n2];
                    labels.add(h);
                    ++n2;
                }
            }
        }
    }
}

