/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.dialog;

import java.awt.Color;
import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.dialog.FreeColConfirmDialog;
import net.sf.freecol.client.gui.label.GoodsLabel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;

public final class WarehouseDialog
extends FreeColConfirmDialog {
    private static final Logger logger = Logger.getLogger(WarehouseDialog.class.getName());
    private JPanel warehousePanel = new MigPanel(new MigLayout("wrap 4"));

    public WarehouseDialog(FreeColClient freeColClient, JFrame frame, Colony colony) {
        super(freeColClient, frame);
        this.warehousePanel.setOpaque(false);
        for (GoodsType type : freeColClient.getGame().getSpecification().getStorableGoodsTypeList()) {
            this.warehousePanel.add(new WarehouseGoodsPanel(freeColClient, colony, type));
        }
        JScrollPane scrollPane = new JScrollPane(this.warehousePanel, 20, 30);
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setBorder(null);
        MigPanel panel = new MigPanel(new MigLayout("fill, wrap 1", "", ""));
        panel.add((Component)Utility.localizedHeader(Messages.nameKey("warehouseDialog"), Utility.FONTSPEC_TITLE), "align center");
        panel.add((Component)scrollPane, "grow");
        panel.setSize(panel.getPreferredSize());
        ImageIcon icon = new ImageIcon(this.getImageLibrary().getSmallSettlementImage(colony));
        this.initializeConfirmDialog(frame, true, panel, icon, "ok", "cancel");
    }

    @Override
    public Boolean getResponse() {
        Boolean result = (Boolean)super.getResponse();
        if (result.booleanValue()) {
            for (Component c : this.warehousePanel.getComponents()) {
                if (!(c instanceof WarehouseGoodsPanel)) continue;
                ((WarehouseGoodsPanel)c).saveSettings();
            }
        }
        this.warehousePanel = null;
        return result;
    }

    private class WarehouseGoodsPanel
    extends MigPanel {
        private final Colony colony;
        private final GoodsType goodsType;
        private final JCheckBox export;
        private final JSpinner lowLevel;
        private final JSpinner highLevel;
        private final JSpinner importLevel;
        private final JSpinner exportLevel;

        public WarehouseGoodsPanel(FreeColClient freeColClient, Colony colony, GoodsType goodsType) {
            super("WarehouseGoodsPanelUI", new MigLayout("wrap 2", "", ""));
            boolean enhancedTradeRoutes = colony.getSpecification().getBoolean("model.option.enhancedTradeRoutes");
            this.colony = colony;
            this.goodsType = goodsType;
            int capacity = colony.getWarehouseCapacity();
            int maxCapacity = 300;
            this.setOpaque(false);
            this.setBorder(Utility.localizedBorder(goodsType, new Color(0)));
            Utility.padBorder(this, 6, 6, 6, 6);
            ExportData exportData = colony.getExportData(goodsType);
            Goods goods = new Goods(colony.getGame(), colony, goodsType, colony.getGoodsCount(goodsType));
            GoodsLabel goodsLabel = new GoodsLabel(freeColClient, goods);
            goodsLabel.setHorizontalAlignment(10);
            this.add((Component)goodsLabel, "span 1 2");
            SpinnerNumberModel lowLevelModel = new SpinnerNumberModel(exportData.getLowLevel(), 0, 100, 1);
            this.lowLevel = new JSpinner(lowLevelModel);
            Utility.localizeToolTip((JComponent)this.lowLevel, "warehouseDialog.lowLevel.shortDescription");
            this.add(this.lowLevel);
            SpinnerNumberModel highLevelModel = new SpinnerNumberModel(exportData.getHighLevel(), 0, 100, 1);
            this.highLevel = new JSpinner(highLevelModel);
            Utility.localizeToolTip((JComponent)this.highLevel, "warehouseDialog.highLevel.shortDescription");
            this.add(this.highLevel);
            if (enhancedTradeRoutes) {
                int importInit = exportData.getEffectiveImportLevel(capacity);
                SpinnerNumberModel importLevelModel = new SpinnerNumberModel(importInit, 0, goodsType.limitIgnored() ? 300 : capacity, 1);
                this.importLevel = new JSpinner(importLevelModel);
                Utility.localizeToolTip((JComponent)this.importLevel, "warehouseDialog.importLevel.shortDescription");
                this.add(this.importLevel);
            } else {
                this.importLevel = null;
            }
            this.export = new JCheckBox(Messages.message("warehouseDialog.export"), exportData.getExported());
            Utility.localizeToolTip((JComponent)this.export, "warehouseDialog.export.shortDescription");
            if (!colony.hasAbility("model.ability.export")) {
                this.export.setEnabled(false);
            }
            this.add(this.export);
            SpinnerNumberModel exportLevelModel = new SpinnerNumberModel(exportData.getExportLevel(), 0, goodsType.limitIgnored() ? 300 : capacity, 1);
            this.exportLevel = new JSpinner(exportLevelModel);
            Utility.localizeToolTip((JComponent)this.exportLevel, "warehouseDialog.exportLevel.shortDescription");
            this.add(this.exportLevel);
            this.setSize(this.getPreferredSize());
        }

        public void saveSettings() {
            int lowLevelValue = ((SpinnerNumberModel)this.lowLevel.getModel()).getNumber().intValue();
            int highLevelValue = ((SpinnerNumberModel)this.highLevel.getModel()).getNumber().intValue();
            int importLevelValue = this.importLevel == null ? -1 : ((SpinnerNumberModel)this.importLevel.getModel()).getNumber().intValue();
            int exportLevelValue = ((SpinnerNumberModel)this.exportLevel.getModel()).getNumber().intValue();
            ExportData exportData = this.colony.getExportData(this.goodsType);
            int importValue = exportData.getEffectiveImportLevel(this.colony.getWarehouseCapacity());
            boolean changed = this.export.isSelected() != exportData.getExported() || lowLevelValue != exportData.getLowLevel() || highLevelValue != exportData.getHighLevel() || this.importLevel != null && importLevelValue != importValue || exportLevelValue != exportData.getExportLevel();
            exportData.setExported(this.export.isSelected());
            exportData.setLowLevel(lowLevelValue);
            exportData.setHighLevel(highLevelValue);
            exportData.setImportLevel(importLevelValue);
            exportData.setExportLevel(exportLevelValue);
            if (changed) {
                WarehouseDialog.this.freeColClient.getInGameController().setGoodsLevels(this.colony, this.goodsType);
            }
        }
    }
}

