/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Member;
import java.util.Iterator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.InterfaceAdapter;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VMBridge {
    static final VMBridge instance = VMBridge.makeInstance();

    private static VMBridge makeInstance() {
        String[] stringArray = new String[]{"org.mozilla.javascript.VMBridge_custom", "org.mozilla.javascript.jdk15.VMBridge_jdk15", "org.mozilla.javascript.jdk13.VMBridge_jdk13", "org.mozilla.javascript.jdk11.VMBridge_jdk11"};
        int n = 0;
        while (n != stringArray.length) {
            VMBridge vMBridge;
            String string = stringArray[n];
            Class<?> clazz = Kit.classOrNull(string);
            if (clazz != null && (vMBridge = (VMBridge)Kit.newInstanceOrNull(clazz)) != null) {
                return vMBridge;
            }
            ++n;
        }
        throw new IllegalStateException("Failed to create VMBridge instance");
    }

    protected abstract Object getThreadContextHelper();

    protected abstract Context getContext(Object var1);

    protected abstract void setContext(Object var1, Context var2);

    protected abstract ClassLoader getCurrentThreadClassLoader();

    protected abstract boolean tryToMakeAccessible(Object var1);

    protected Object getInterfaceProxyHelper(ContextFactory contextFactory, Class<?>[] classArray) {
        throw Context.reportRuntimeError("VMBridge.getInterfaceProxyHelper is not supported");
    }

    protected Object newInterfaceProxy(Object object, ContextFactory contextFactory, InterfaceAdapter interfaceAdapter, Object object2, Scriptable scriptable) {
        throw Context.reportRuntimeError("VMBridge.newInterfaceProxy is not supported");
    }

    protected abstract boolean isVarArgs(Member var1);

    public Iterator<?> getJavaIterator(Context context, Scriptable scriptable, Object object) {
        if (object instanceof Wrapper) {
            Object object2 = ((Wrapper)object).unwrap();
            Iterator iterator = null;
            if (object2 instanceof Iterator) {
                iterator = (Iterator)object2;
            }
            return iterator;
        }
        return null;
    }
}

