/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data;

import jadx.plugins.input.java.data.ConstPoolReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DataReader {
    private final byte[] data;
    private int offset;

    public DataReader(byte[] data) {
        this(data, 0);
    }

    public DataReader(byte[] data, int offset) {
        this.data = data;
        this.offset = offset;
    }

    public DataReader copy() {
        return new DataReader(this.data, this.offset);
    }

    public DataReader absPos(int offset) {
        this.offset = offset;
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public void skip(int size) {
        this.offset += size;
    }

    public int readS1() {
        int pos = this.offset;
        byte b1 = this.data[pos];
        this.offset = pos + 1;
        return b1;
    }

    public int readU1() {
        int pos = this.offset;
        byte b1 = this.data[pos];
        this.offset = pos + 1;
        return b1 & 0xFF;
    }

    public int readS2() {
        int pos = this.offset;
        byte[] d = this.data;
        byte b1 = d[pos++];
        byte b2 = d[pos++];
        this.offset = pos;
        return b1 << 8 | b2 & 0xFF;
    }

    public int readU2() {
        int pos = this.offset;
        byte[] d = this.data;
        byte b1 = d[pos++];
        byte b2 = d[pos++];
        this.offset = pos;
        return (b1 & 0xFF) << 8 | b2 & 0xFF;
    }

    public int readS4() {
        int pos = this.offset;
        byte[] d = this.data;
        byte b1 = d[pos++];
        byte b2 = d[pos++];
        byte b3 = d[pos++];
        byte b4 = d[pos++];
        this.offset = pos;
        return b1 << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    public int readU4() {
        int pos = this.offset;
        byte[] d = this.data;
        byte b1 = d[pos++];
        byte b2 = d[pos++];
        byte b3 = d[pos++];
        byte b4 = d[pos++];
        this.offset = pos;
        return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    public long readS8() {
        long high = this.readS4();
        long low = (long)this.readU4() & 0xFFFFFFFFL;
        return high << 32 | low;
    }

    public long readU8() {
        long high = (long)this.readU4() & 0xFFFFFFFFL;
        long low = (long)this.readU4() & 0xFFFFFFFFL;
        return high << 32 | low;
    }

    public byte[] readBytes(int len) {
        int pos = this.offset;
        this.offset = pos + len;
        return Arrays.copyOfRange(this.data, pos, pos + len);
    }

    public List<String> readClassesList(ConstPoolReader constPool) {
        int len = this.readU2();
        if (len == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            list.add(constPool.getClass(this.readU2()));
        }
        return list;
    }

    public byte[] getBytes() {
        return this.data;
    }
}

