/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils.android;

import jadx.core.utils.exceptions.JadxRuntimeException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class TextResMapFile {
    private static final int SPLIT_POS = 8;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<Integer, String> read(InputStream is) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            HashMap<Integer, String> resMap = new HashMap<Integer, String>();
            while (true) {
                String line;
                if ((line = br.readLine()) == null) {
                    HashMap<Integer, String> hashMap = resMap;
                    return hashMap;
                }
                TextResMapFile.parseLine(resMap, line);
            }
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to read res-map file", e);
        }
    }

    private static void parseLine(Map<Integer, String> resMap, String line) {
        int id = Integer.parseInt(line.substring(0, 8), 16);
        String name = line.substring(9);
        resMap.put(id, name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<Integer, String> read(Path resMapFile) {
        try (InputStream in = Files.newInputStream(resMapFile, new OpenOption[0]);){
            Map<Integer, String> map = TextResMapFile.read(in);
            return map;
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to read res-map file", e);
        }
    }

    public static void write(Path resMapFile, Map<Integer, String> inputResMap) {
        try {
            TreeMap<Integer, String> resMap = new TreeMap<Integer, String>(inputResMap);
            ArrayList<String> lines = new ArrayList<String>(resMap.size());
            for (Map.Entry entry : resMap.entrySet()) {
                lines.add(String.format("%08x=%s", entry.getKey(), entry.getValue()));
            }
            Files.write(resMapFile, lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to write res-map file", e);
        }
    }
}

