/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.util;

import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010&\n\u0002\b\u0007\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001b\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\u0004J\u0015\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/nlj/util/TreeCache;", "T", "", "minSize", "", "<init>", "(I)V", "map", "Ljava/util/TreeMap;", "highestIndex", "insert", "", "index", "value", "(ILjava/lang/Object;)V", "getEntryBefore", "", "get", "(I)Ljava/lang/Object;", "updateState", "size", "getSize", "()I", "jitsi-media-transform"})
public class TreeCache<T> {
    private final int minSize;
    @NotNull
    private final TreeMap<Integer, T> map;
    private int highestIndex;

    public TreeCache(int minSize) {
        this.minSize = minSize;
        this.map = new TreeMap();
        this.highestIndex = -1;
    }

    public final void insert(int index, T value2) {
        Integer n = index;
        ((Map)this.map).put(n, value2);
        this.updateState(index);
    }

    @Nullable
    public final Map.Entry<Integer, T> getEntryBefore(int index) {
        this.updateState(index);
        return this.map.floorEntry(index);
    }

    @Nullable
    public final T get(int index) {
        return this.map.get(index);
    }

    private final void updateState(int index) {
        SortedMap<Integer, T> headMap;
        if (this.highestIndex < index) {
            this.highestIndex = index;
        }
        if ((headMap = this.map.headMap(this.highestIndex - this.minSize)).size() > 1) {
            Set<Integer> set = headMap.keySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
            Integer last = (Integer)CollectionsKt.last((Iterable)set);
            headMap.keySet().removeIf(arg_0 -> TreeCache.updateState$lambda$1(arg_0 -> TreeCache.updateState$lambda$0(last, arg_0), arg_0));
        }
    }

    public final int getSize() {
        return this.map.size();
    }

    private static final boolean updateState$lambda$0(Integer $last, Integer it) {
        return it < $last;
    }

    private static final boolean updateState$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

