/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.Dot11InformationElement;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.Dot11InformationElementId;
import org.pcap4j.util.ByteArrays;

public final class Dot11DsssParameterSetElement
extends Dot11InformationElement {
    private static final long serialVersionUID = 3289074676325930942L;
    private final byte currentChannel;

    public static Dot11DsssParameterSetElement newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Dot11DsssParameterSetElement(rawData, offset, length);
    }

    private Dot11DsssParameterSetElement(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        super(rawData, offset, length, Dot11InformationElementId.DSSS_PARAMETER_SET);
        if (this.getLengthAsInt() != 1) {
            throw new IllegalRawDataException("The length must be 1 but is actually: " + this.getLengthAsInt());
        }
        this.currentChannel = rawData[offset + 2];
    }

    private Dot11DsssParameterSetElement(Builder builder2) {
        super(builder2);
        this.currentChannel = builder2.currentChannel;
    }

    public byte getCurrentChannel() {
        return this.currentChannel;
    }

    public int getCurrentChannelAsInt() {
        return this.currentChannel & 0xFF;
    }

    @Override
    public int length() {
        return 3;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[]{(Byte)this.getElementId().value(), this.getLength(), this.currentChannel};
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.currentChannel;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Dot11DsssParameterSetElement other = (Dot11DsssParameterSetElement)obj;
        return this.currentChannel == other.currentChannel;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("DSSS Parameter Set:").append(ls);
        sb.append(indent).append("  Element ID: ").append(this.getElementId()).append(ls);
        sb.append(indent).append("  Length: ").append(this.getLengthAsInt()).append(" bytes").append(ls);
        sb.append(indent).append("  Current Channel: ").append(this.getCurrentChannelAsInt()).append(ls);
        return sb.toString();
    }

    public static final class Builder
    extends Dot11InformationElement.Builder {
        private byte currentChannel;

        public Builder() {
            this.elementId(Dot11InformationElementId.getInstance((Byte)Dot11InformationElementId.DSSS_PARAMETER_SET.value()));
        }

        private Builder(Dot11DsssParameterSetElement elem) {
            super(elem);
            this.currentChannel = elem.currentChannel;
        }

        public Builder currentChannel(byte currentChannel) {
            this.currentChannel = currentChannel;
            return this;
        }

        @Override
        public Builder length(byte length) {
            super.length(length);
            return this;
        }

        @Override
        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            super.correctLengthAtBuild(correctLengthAtBuild);
            return this;
        }

        @Override
        public Dot11DsssParameterSetElement build() {
            if (this.getCorrectLengthAtBuild()) {
                this.length((byte)1);
            }
            return new Dot11DsssParameterSetElement(this);
        }
    }
}

