/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import org.apache.commons.jcs.engine.CacheEventQueue;
import org.apache.commons.jcs.engine.PooledCacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheEventQueueFactory<K, V> {
    private static final Log log = LogFactory.getLog(CacheEventQueueFactory.class);

    public ICacheEventQueue<K, V> createCacheEventQueue(ICacheListener<K, V> listener, long listenerId, String cacheName, String threadPoolName, ICacheEventQueue.QueueType poolType) {
        return this.createCacheEventQueue(listener, listenerId, cacheName, 10, 500, threadPoolName, poolType);
    }

    public ICacheEventQueue<K, V> createCacheEventQueue(ICacheListener<K, V> listener, long listenerId, String cacheName, int maxFailure, int waitBeforeRetry, String threadPoolName, ICacheEventQueue.QueueType poolType) {
        if (log.isDebugEnabled()) {
            log.debug("threadPoolName = [" + threadPoolName + "] poolType = " + (Object)((Object)poolType) + " ");
        }
        PooledCacheEventQueue eventQueue = null;
        if (poolType == null || ICacheEventQueue.QueueType.SINGLE == poolType) {
            eventQueue = new CacheEventQueue<K, V>(listener, listenerId, cacheName, maxFailure, waitBeforeRetry);
        } else if (ICacheEventQueue.QueueType.POOLED == poolType) {
            eventQueue = new PooledCacheEventQueue<K, V>(listener, listenerId, cacheName, maxFailure, waitBeforeRetry, threadPoolName);
        }
        return eventQueue;
    }
}

