/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.io.session.SessionLayerExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.UserCancelException;
import org.openstreetmap.josm.tools.Utils;

public class SessionSaveAsAction
extends DiskAccessAction
implements MapFrameListener {
    private transient List<Layer> layers;
    private transient Map<Layer, SessionLayerExporter> exporters;
    private transient MultiMap<Layer, Layer> dependencies;

    public SessionSaveAsAction() {
        this(true, true);
    }

    protected SessionSaveAsAction(boolean toolbar, boolean installAdapters) {
        super(I18n.tr("Save Session As...", new Object[0]), "session", I18n.tr("Save the current session to a new file.", new Object[0]), null, toolbar, "save_as-session", installAdapters);
        this.setHelpId(HelpUtil.ht("/Action/SessionSaveAs"));
        MainApplication.addMapFrameListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.saveSession();
        }
        catch (UserCancelException ignore) {
            Logging.trace(ignore);
        }
    }

    @Override
    public void destroy() {
        MainApplication.removeMapFrameListener(this);
        super.destroy();
    }

    public void saveSession() throws UserCancelException {
        if (!this.isEnabled()) {
            return;
        }
        SessionSaveAsDialog dlg = new SessionSaveAsDialog();
        dlg.showDialog();
        if (dlg.getValue() != 1) {
            throw new UserCancelException();
        }
        boolean zipRequired = false;
        for (Layer l : this.layers) {
            SessionLayerExporter ex = this.exporters.get(l);
            if (ex == null || !ex.requiresZip()) continue;
            zipRequired = true;
            break;
        }
        ExtensionFileFilter joz = new ExtensionFileFilter("joz", "joz", I18n.tr("Session file (archive) (*.joz)", new Object[0]));
        ExtensionFileFilter jos = new ExtensionFileFilter("jos", "jos", I18n.tr("Session file (*.jos)", new Object[0]));
        AbstractFileChooser fc = zipRequired ? SessionSaveAsAction.createAndOpenFileChooser(false, false, I18n.tr("Save Session", new Object[0]), joz, 0, "lastDirectory") : SessionSaveAsAction.createAndOpenFileChooser(false, false, I18n.tr("Save Session", new Object[0]), Arrays.asList(jos, joz), jos, 0, "lastDirectory");
        if (fc == null) {
            throw new UserCancelException();
        }
        File file = fc.getSelectedFile();
        String fn = file.getName();
        FileFilter ff = fc.getFileFilter();
        boolean zip = zipRequired || ((Object)joz).equals(ff) ? true : (((Object)jos).equals(ff) ? false : Utils.hasExtension(fn, "joz"));
        if (fn.indexOf(46) == -1 && !SaveActionBase.confirmOverwrite(file = new File(file.getPath() + (zip ? ".joz" : ".jos")))) {
            throw new UserCancelException();
        }
        ArrayList<Layer> layersOut = new ArrayList<Layer>();
        for (Layer layer : this.layers) {
            if (this.exporters.get(layer) == null || !this.exporters.get(layer).shallExport()) continue;
            layersOut.add(layer);
        }
        int active = -1;
        Layer activeLayer = this.getLayerManager().getActiveLayer();
        if (activeLayer != null) {
            active = layersOut.indexOf(activeLayer);
        }
        SessionWriter sw = new SessionWriter(layersOut, active, this.exporters, this.dependencies, zip);
        try {
            sw.write(file);
            SaveActionBase.addToFileOpenHistory(file);
        }
        catch (IOException ex) {
            Logging.error(ex);
            HelpAwareOptionPane.showMessageDialogInEDT(MainApplication.getMainFrame(), I18n.tr("<html>Could not save session file ''{0}''.<br>Error is:<br>{1}</html>", file.getName(), Utils.escapeReservedCharactersHTML(ex.getMessage())), I18n.tr("IO Error", new Object[0]), 0, null);
        }
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(MainApplication.isDisplayingMapView());
    }

    @Override
    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        this.updateEnabledState();
    }

    public class SessionSaveAsDialog
    extends ExtendedDialog {
        public SessionSaveAsDialog() {
            super((Component)MainApplication.getMainFrame(), I18n.tr("Save Session", new Object[0]), I18n.tr("Save As", new Object[0]), I18n.tr("Cancel", new Object[0]));
            this.configureContextsensitiveHelp("Action/SessionSaveAs", true);
            this.initialize();
            this.setButtonIcons("save_as", "cancel");
            this.setDefaultButton(1);
            this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(MainApplication.getMainFrame(), new Dimension(450, 450)));
            this.setContent(this.build(), false);
        }

        public final void initialize() {
            SessionSaveAsAction.this.layers = new ArrayList<Layer>(SessionSaveAsAction.this.getLayerManager().getLayers());
            SessionSaveAsAction.this.exporters = new HashMap();
            SessionSaveAsAction.this.dependencies = new MultiMap();
            HashSet<Layer> noExporter = new HashSet<Layer>();
            for (Layer layer : SessionSaveAsAction.this.layers) {
                SessionLayerExporter exporter = SessionWriter.getSessionLayerExporter(layer);
                if (exporter != null) {
                    SessionSaveAsAction.this.exporters.put(layer, exporter);
                    Collection<Layer> deps = exporter.getDependencies();
                    if (deps != null) {
                        SessionSaveAsAction.this.dependencies.putAll(layer, deps);
                        continue;
                    }
                    SessionSaveAsAction.this.dependencies.putVoid(layer);
                    continue;
                }
                noExporter.add(layer);
                SessionSaveAsAction.this.exporters.put(layer, null);
            }
            int numNoExporter = 0;
            block1: while (numNoExporter != noExporter.size()) {
                numNoExporter = noExporter.size();
                for (Layer layer : SessionSaveAsAction.this.layers) {
                    if (noExporter.contains(layer)) continue;
                    for (Layer depLayer : SessionSaveAsAction.this.dependencies.get(layer)) {
                        if (!noExporter.contains(depLayer)) continue;
                        noExporter.add(layer);
                        SessionSaveAsAction.this.exporters.put(layer, null);
                        break block1;
                    }
                }
            }
        }

        protected final Component build() {
            JPanel ip = new JPanel(new GridBagLayout());
            for (Layer layer : SessionSaveAsAction.this.layers) {
                Component exportPanel;
                JPanel wrapper = new JPanel(new GridBagLayout());
                wrapper.setBorder(BorderFactory.createEtchedBorder(0));
                SessionLayerExporter exporter = (SessionLayerExporter)SessionSaveAsAction.this.exporters.get(layer);
                if (exporter == null) {
                    if (!SessionSaveAsAction.this.exporters.containsKey(layer)) {
                        throw new AssertionError();
                    }
                    exportPanel = this.getDisabledExportPanel(layer);
                } else {
                    exportPanel = exporter.getExportPanel();
                }
                wrapper.add(exportPanel, GBC.std().fill(2));
                ip.add((Component)wrapper, GBC.eol().fill(2).insets(2, 2, 4, 2));
            }
            ip.add(GBC.glue(0, 1), GBC.eol().fill(3));
            JScrollPane sp = new JScrollPane(ip);
            sp.setBorder(BorderFactory.createEmptyBorder());
            JPanel p = new JPanel(new GridBagLayout());
            p.add((Component)sp, GBC.eol().fill());
            JTabbedPane tabs = new JTabbedPane();
            tabs.addTab(I18n.tr("Layers", new Object[0]), p);
            return tabs;
        }

        protected final Component getDisabledExportPanel(Layer layer) {
            JPanel p = new JPanel(new GridBagLayout());
            JCheckBox include = new JCheckBox();
            include.setEnabled(false);
            JLabel lbl = new JLabel(layer.getName(), layer.getIcon(), 2);
            lbl.setToolTipText(I18n.tr("No exporter for this layer", new Object[0]));
            lbl.setLabelFor(include);
            lbl.setEnabled(false);
            p.add((Component)include, GBC.std());
            p.add((Component)lbl, GBC.std());
            p.add(GBC.glue(1, 0), GBC.std().fill(2));
            return p;
        }
    }
}

