/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.tools.I18n;

public class MapScaler
extends JComponent
implements Helpful,
Accessible {
    private final NavigatableComponent mv;
    private static final int PADDING_LEFT = 5;
    private static final int PADDING_RIGHT = 50;
    private static final NamedColorProperty SCALER_COLOR = new NamedColorProperty(I18n.marktr("scale"), Color.WHITE);

    public MapScaler(NavigatableComponent mv) {
        this.mv = mv;
        this.setPreferredLineLength(100);
        this.setOpaque(false);
    }

    public void setPreferredLineLength(int pixel) {
        this.setPreferredSize(new Dimension(pixel + 5 + 50, 30));
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(MapScaler.getColor());
        double dist100Pixel = this.mv.getDist100Pixel(true);
        TickMarks tickMarks = new TickMarks(dist100Pixel, this.getWidth() - 5 - 50);
        tickMarks.paintTicks(g);
    }

    public static Color getColor() {
        return SCALER_COLOR.get();
    }

    @Override
    public String helpTopic() {
        return HelpUtil.ht("/MapView/Scaler");
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMapScaler();
        }
        return this.accessibleContext;
    }

    private static final class TickMarks {
        private final double dist100Pixel;
        private final double spacingMeter;
        private final int steps;
        private final int minorStepsPerMajor;

        TickMarks(double dist100Pixel, int width) {
            int minorStepsPerMajor;
            double distanceBetweenMinor;
            this.dist100Pixel = dist100Pixel;
            double lineDistance = dist100Pixel * (double)width / 100.0;
            double log10 = Math.log(lineDistance) / Math.log(10.0);
            double spacingLog10 = Math.pow(10.0, Math.floor(log10));
            if (log10 - Math.floor(log10) < 0.75) {
                distanceBetweenMinor = spacingLog10 / 2.0;
                minorStepsPerMajor = 2;
            } else {
                distanceBetweenMinor = spacingLog10;
                minorStepsPerMajor = 5;
            }
            int majorSteps = (int)Math.floor(lineDistance / distanceBetweenMinor / (double)minorStepsPerMajor);
            if (majorSteps >= 4) {
                this.spacingMeter = distanceBetweenMinor * (double)minorStepsPerMajor;
                this.minorStepsPerMajor = 1;
            } else {
                this.minorStepsPerMajor = minorStepsPerMajor;
                this.spacingMeter = distanceBetweenMinor;
            }
            this.steps = majorSteps * this.minorStepsPerMajor;
        }

        public void paintTicks(Graphics g) {
            double spacingPixel = this.spacingMeter / (this.dist100Pixel / 100.0);
            double textBlockedUntil = -1.0;
            for (int step = 0; step <= this.steps; ++step) {
                int x = (int)(5.0 + spacingPixel * (double)step);
                boolean isMajor = step % this.minorStepsPerMajor == 0;
                int paddingY = isMajor ? 0 : 3;
                g.drawLine(x, paddingY, x, 10 - paddingY);
                if (step != 0 && step != this.steps) continue;
                String text = step == 0 ? "0" : NavigatableComponent.getDistText(this.spacingMeter * (double)step);
                Rectangle2D bound = g.getFontMetrics().getStringBounds(text, g);
                int left = (int)((double)x - bound.getWidth() / 2.0);
                if (textBlockedUntil > (double)left) {
                    left = (int)(textBlockedUntil + 5.0);
                }
                g.drawString(text, left, 23);
                textBlockedUntil = (double)left + bound.getWidth() + 2.0;
            }
            g.drawLine(5, 5, (int)(5.0 + spacingPixel * (double)this.steps), 5);
        }
    }

    class AccessibleMapScaler
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        AccessibleMapScaler() {
            super(MapScaler.this);
        }

        @Override
        public Number getCurrentAccessibleValue() {
            return MapScaler.this.mv.getDist100Pixel();
        }

        @Override
        public boolean setCurrentAccessibleValue(Number n) {
            return false;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return null;
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return null;
        }
    }
}

