/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.sort;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSortUtils;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;

public class RelationNodeMap {
    private static final String ROLE_BACKWARD = "backward";
    private final NodesWays map = new NodesWays(false);
    private final NodesWays onewayMap = new NodesWays(true);
    private final NodesWays onewayReverseMap = new NodesWays(true);
    private final Set<Integer> remaining = new TreeSet<Integer>();
    private final Map<Integer, Set<Node>> remainingOneway = new TreeMap<Integer, Set<Node>>();
    private final List<Integer> notSortable = new ArrayList<Integer>();
    private Integer firstOneway;
    private Node lastOnewayNode;
    private Node firstCircular;

    public static Node firstOnewayNode(RelationMember m) {
        if (!m.isWay()) {
            return null;
        }
        if (ROLE_BACKWARD.equals(m.getRole())) {
            return m.getWay().lastNode();
        }
        return m.getWay().firstNode();
    }

    public static Node lastOnewayNode(RelationMember m) {
        if (!m.isWay()) {
            return null;
        }
        if (ROLE_BACKWARD.equals(m.getRole())) {
            return m.getWay().firstNode();
        }
        return m.getWay().lastNode();
    }

    RelationNodeMap(List<RelationMember> members) {
        for (int i = 0; i < members.size(); ++i) {
            RelationMember m = members.get(i);
            if (m.getMember().isIncomplete() || !m.isWay() || m.getWay().getNodesCount() < 2) {
                this.notSortable.add(i);
                continue;
            }
            Way w = m.getWay();
            if (RelationSortUtils.roundaboutType(w) != WayConnectionType.Direction.NONE) {
                for (Node nd : w.getNodes()) {
                    this.addPair(nd, i);
                }
                continue;
            }
            if (RelationSortUtils.isOneway(m)) {
                this.addNodeWayMap(RelationNodeMap.firstOnewayNode(m), i);
                this.addWayNodeMap(RelationNodeMap.lastOnewayNode(m), i);
                this.addNodeWayMapReverse(RelationNodeMap.lastOnewayNode(m), i);
                this.addWayNodeMapReverse(RelationNodeMap.firstOnewayNode(m), i);
                this.addRemainingForward(RelationNodeMap.firstOnewayNode(m), i);
                this.addRemainingForward(RelationNodeMap.lastOnewayNode(m), i);
                continue;
            }
            this.addPair(w.firstNode(), i);
            this.addPair(w.lastNode(), i);
        }
        this.remaining.addAll(this.map.ways.keySet());
    }

    private void addPair(Node n, int i) {
        this.map.nodes.computeIfAbsent(n, k -> new TreeSet()).add(i);
        this.map.ways.computeIfAbsent(i, k -> new TreeSet()).add(n);
    }

    private void addNodeWayMap(Node n, int i) {
        this.onewayMap.nodes.computeIfAbsent(n, k -> new TreeSet()).add(i);
    }

    private void addWayNodeMap(Node n, int i) {
        this.onewayMap.ways.computeIfAbsent(i, k -> new TreeSet()).add(n);
    }

    private void addNodeWayMapReverse(Node n, int i) {
        this.onewayReverseMap.nodes.computeIfAbsent(n, k -> new TreeSet()).add(i);
    }

    private void addWayNodeMapReverse(Node n, int i) {
        this.onewayReverseMap.ways.computeIfAbsent(i, k -> new TreeSet()).add(n);
    }

    private void addRemainingForward(Node n, int i) {
        this.remainingOneway.computeIfAbsent(i, k -> new TreeSet()).add(n);
    }

    public Integer popAdjacent(Integer way) {
        if (this.lastOnewayNode != null) {
            return this.popBackwardOnewayPart(way);
        }
        if (this.firstOneway != null) {
            return this.popForwardOnewayPart(way);
        }
        if (this.map.ways.containsKey(way)) {
            for (Node n : this.map.ways.get(way)) {
                Integer i = this.deleteAndGetAdjacentNode(this.map, n);
                if (i != null) {
                    return i;
                }
                Integer j = this.deleteAndGetAdjacentNode(this.onewayMap, n);
                if (j == null) continue;
                this.firstOneway = j;
                return j;
            }
        }
        this.firstOneway = way;
        return this.popForwardOnewayPart(way);
    }

    private Integer popForwardOnewayPart(Integer way) {
        if (this.onewayMap.ways.containsKey(way)) {
            for (Node n : this.onewayMap.ways.get(way)) {
                Integer i = RelationNodeMap.findAdjacentWay(this.onewayMap, n);
                if (i == null) continue;
                this.lastOnewayNode = this.processBackwardIfEndOfLoopReached(i);
                if (this.lastOnewayNode != null) {
                    return this.popBackwardOnewayPart(this.firstOneway);
                }
                this.deleteWayNode(this.onewayMap, i, n);
                return i;
            }
        }
        this.firstOneway = null;
        return null;
    }

    private Node processBackwardIfEndOfLoopReached(Integer way) {
        if (this.onewayReverseMap.ways.containsKey(way)) {
            for (Node n : this.onewayReverseMap.ways.get(way)) {
                if (this.map.nodes.containsKey(n) || this.onewayMap.nodes.containsKey(n) && this.onewayMap.nodes.get(n).size() > 1) {
                    return n;
                }
                if (this.firstCircular == null || this.firstCircular != n) continue;
                return this.firstCircular;
            }
        }
        return null;
    }

    private Integer popBackwardOnewayPart(int way) {
        if (this.lastOnewayNode != null) {
            TreeSet nodes = new TreeSet();
            if (this.onewayReverseMap.ways.containsKey(way)) {
                nodes.addAll(this.onewayReverseMap.ways.get(way));
            }
            if (this.map.ways.containsKey(way)) {
                nodes.addAll(this.map.ways.get(way));
            }
            for (Node n : nodes) {
                Integer j;
                if (n == this.lastOnewayNode) {
                    this.firstOneway = null;
                    this.lastOnewayNode = null;
                    j = this.deleteAndGetAdjacentNode(this.map, n);
                    if (j != null) {
                        return j;
                    }
                    Integer k = this.deleteAndGetAdjacentNode(this.onewayMap, n);
                    if (k != null) {
                        this.firstOneway = k;
                        return k;
                    }
                }
                if ((j = this.deleteAndGetAdjacentNode(this.onewayReverseMap, n)) == null) continue;
                return j;
            }
        }
        this.firstOneway = null;
        this.lastOnewayNode = null;
        return null;
    }

    private Integer deleteAndGetAdjacentNode(NodesWays nw, Node n) {
        Integer j = RelationNodeMap.findAdjacentWay(nw, n);
        if (j == null) {
            return null;
        }
        this.deleteWayNode(nw, j, n);
        return j;
    }

    private static Integer findAdjacentWay(NodesWays nw, Node n) {
        Set<Integer> adj = nw.nodes.get(n);
        if (adj == null || adj.isEmpty()) {
            return null;
        }
        return adj.iterator().next();
    }

    private void deleteWayNode(NodesWays nw, Integer way, Node n) {
        if (nw.oneWay) {
            this.doneOneway(way);
        } else {
            this.done(way);
        }
        nw.ways.get(way).remove(n);
    }

    public Integer pop() {
        if (!this.remaining.isEmpty()) {
            Integer i = this.remaining.iterator().next();
            this.done(i);
            return i;
        }
        if (this.remainingOneway.isEmpty()) {
            return null;
        }
        for (Integer i : this.remainingOneway.keySet()) {
            for (Node n : this.onewayReverseMap.ways.get(i)) {
                if (!this.onewayReverseMap.nodes.containsKey(n) || this.onewayReverseMap.nodes.get(n).size() <= 1) continue;
                this.doneOneway(i);
                this.firstCircular = n;
                return i;
            }
        }
        Integer i = this.remainingOneway.keySet().iterator().next();
        this.doneOneway(i);
        return i;
    }

    private void doneOneway(Integer i) {
        Set<Node> nodesForward = this.remainingOneway.get(i);
        for (Node n : nodesForward) {
            if (this.onewayMap.nodes.containsKey(n)) {
                this.onewayMap.nodes.get(n).remove(i);
            }
            if (!this.onewayReverseMap.nodes.containsKey(n)) continue;
            this.onewayReverseMap.nodes.get(n).remove(i);
        }
        this.remainingOneway.remove(i);
    }

    private void done(Integer i) {
        this.remaining.remove(i);
        Set<Node> nodes = this.map.ways.get(i);
        for (Node n : nodes) {
            boolean result = this.map.nodes.get(n).remove(i);
            if (!result) {
                throw new AssertionError();
            }
        }
    }

    public List<Integer> getNotSortableMembers() {
        return this.notSortable;
    }

    private static class NodesWays {
        public final Map<Node, Set<Integer>> nodes = new TreeMap<Node, Set<Integer>>();
        public final Map<Integer, Set<Node>> ways = new TreeMap<Integer, Set<Node>>();
        public final boolean oneWay;

        NodesWays(boolean oneWay) {
            this.oneWay = oneWay;
        }
    }
}

