/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.layer.WMTSLayer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.io.session.GeoImageSessionExporter;
import org.openstreetmap.josm.io.session.GpxTracksSessionExporter;
import org.openstreetmap.josm.io.session.ImagerySessionExporter;
import org.openstreetmap.josm.io.session.MarkerSessionExporter;
import org.openstreetmap.josm.io.session.NoteSessionExporter;
import org.openstreetmap.josm.io.session.OsmDataSessionExporter;
import org.openstreetmap.josm.io.session.SessionLayerExporter;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SessionWriter {
    private static Map<Class<? extends Layer>, Class<? extends SessionLayerExporter>> sessionLayerExporters = new HashMap<Class<? extends Layer>, Class<? extends SessionLayerExporter>>();
    private final List<Layer> layers;
    private final int active;
    private final Map<Layer, SessionLayerExporter> exporters;
    private final MultiMap<Layer, Layer> dependencies;
    private final boolean zip;
    private ZipOutputStream zipOut;

    public static void registerSessionLayerExporter(Class<? extends Layer> layerClass, Class<? extends SessionLayerExporter> exporter) {
        sessionLayerExporters.put(layerClass, exporter);
    }

    public static SessionLayerExporter getSessionLayerExporter(Layer layer) {
        Class<?> layerClass = layer.getClass();
        Class<? extends SessionLayerExporter> exporterClass = sessionLayerExporters.get(layerClass);
        if (exporterClass == null) {
            return null;
        }
        try {
            return exporterClass.getConstructor(layerClass).newInstance(layer);
        }
        catch (ReflectiveOperationException e) {
            throw new JosmRuntimeException(e);
        }
    }

    public SessionWriter(List<Layer> layers, int active, Map<Layer, SessionLayerExporter> exporters, MultiMap<Layer, Layer> dependencies, boolean zip) {
        this.layers = layers;
        this.active = active;
        this.exporters = exporters;
        this.dependencies = dependencies;
        this.zip = zip;
    }

    public Document createJosDocument() throws IOException {
        DocumentBuilder builder = null;
        try {
            builder = XmlUtils.newSafeDOMBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        Document doc = builder.newDocument();
        Element root = doc.createElement("josm-session");
        root.setAttribute("version", "0.1");
        doc.appendChild(root);
        SessionWriter.writeViewPort(root);
        SessionWriter.writeProjection(root);
        Element layersEl = doc.createElement("layers");
        if (this.active >= 0) {
            layersEl.setAttribute("active", Integer.toString(this.active + 1));
        }
        root.appendChild(layersEl);
        for (int index = 0; index < this.layers.size(); ++index) {
            Set<Layer> deps;
            Layer layer = this.layers.get(index);
            SessionLayerExporter exporter = this.exporters.get(layer);
            ExportSupport support = new ExportSupport(doc, index + 1);
            Element el = exporter.export(support);
            el.setAttribute("index", Integer.toString(index + 1));
            el.setAttribute("name", layer.getName());
            el.setAttribute("visible", Boolean.toString(layer.isVisible()));
            if (!Utils.equalsEpsilon(layer.getOpacity(), 1.0)) {
                el.setAttribute("opacity", Double.toString(layer.getOpacity()));
            }
            if ((deps = this.dependencies.get(layer)) != null && !deps.isEmpty()) {
                ArrayList<Integer> depsInt = new ArrayList<Integer>();
                for (Layer depLayer : deps) {
                    int depIndex = this.layers.indexOf(depLayer);
                    if (depIndex == -1) {
                        Logging.warn("Unable to find " + depLayer);
                        continue;
                    }
                    depsInt.add(depIndex + 1);
                }
                if (!depsInt.isEmpty()) {
                    el.setAttribute("depends", Utils.join(",", depsInt));
                }
            }
            layersEl.appendChild(el);
        }
        return doc;
    }

    private static void writeViewPort(Element root) {
        Document doc = root.getOwnerDocument();
        Element viewportEl = doc.createElement("viewport");
        root.appendChild(viewportEl);
        Element centerEl = doc.createElement("center");
        viewportEl.appendChild(centerEl);
        MapView mapView = MainApplication.getMap().mapView;
        EastNorth center = mapView.getCenter();
        LatLon centerLL = ProjectionRegistry.getProjection().eastNorth2latlon(center);
        centerEl.setAttribute("lat", Double.toString(centerLL.lat()));
        centerEl.setAttribute("lon", Double.toString(centerLL.lon()));
        Element scale = doc.createElement("scale");
        viewportEl.appendChild(scale);
        double dist100px = mapView.getDist100Pixel();
        scale.setAttribute("meter-per-pixel", Double.toString(dist100px / 100.0));
    }

    private static void writeProjection(Element root) {
        String code;
        Document doc = root.getOwnerDocument();
        Element projectionEl = doc.createElement("projection");
        root.appendChild(projectionEl);
        String pcId = ProjectionPreference.getCurrentProjectionChoiceId();
        Element projectionChoiceEl = doc.createElement("projection-choice");
        projectionEl.appendChild(projectionChoiceEl);
        Element idEl = doc.createElement("id");
        projectionChoiceEl.appendChild(idEl);
        idEl.setTextContent(pcId);
        Collection<String> parameters = ProjectionPreference.getSubprojectionPreference(pcId);
        Element parametersEl = doc.createElement("parameters");
        projectionChoiceEl.appendChild(parametersEl);
        if (parameters != null) {
            for (String param : parameters) {
                Element paramEl = doc.createElement("param");
                parametersEl.appendChild(paramEl);
                paramEl.setTextContent(param);
            }
        }
        if ((code = ProjectionRegistry.getProjection().toCode()) != null) {
            Element codeEl = doc.createElement("code");
            projectionEl.appendChild(codeEl);
            codeEl.setTextContent(code);
        }
    }

    public void writeJos(Document doc, OutputStream out) throws IOException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
            writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            Transformer trans = XmlUtils.newSafeTransformerFactory().newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(doc);
            trans.transform(source, result);
        }
        catch (TransformerException e) {
            throw new JosmRuntimeException(e);
        }
    }

    public void write(File f) throws IOException {
        try (OutputStream out = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
            this.write(out);
        }
    }

    public void write(OutputStream out) throws IOException {
        if (this.zip) {
            this.zipOut = new ZipOutputStream((OutputStream)new BufferedOutputStream(out), StandardCharsets.UTF_8);
        }
        Document doc = this.createJosDocument();
        if (this.zip) {
            ZipEntry entry = new ZipEntry("session.jos");
            this.zipOut.putNextEntry(entry);
            this.writeJos(doc, this.zipOut);
            Utils.close(this.zipOut);
        } else {
            this.writeJos(doc, new BufferedOutputStream(out));
        }
    }

    static {
        SessionWriter.registerSessionLayerExporter(OsmDataLayer.class, OsmDataSessionExporter.class);
        SessionWriter.registerSessionLayerExporter(TMSLayer.class, ImagerySessionExporter.class);
        SessionWriter.registerSessionLayerExporter(WMSLayer.class, ImagerySessionExporter.class);
        SessionWriter.registerSessionLayerExporter(WMTSLayer.class, ImagerySessionExporter.class);
        SessionWriter.registerSessionLayerExporter(GpxLayer.class, GpxTracksSessionExporter.class);
        SessionWriter.registerSessionLayerExporter(GeoImageLayer.class, GeoImageSessionExporter.class);
        SessionWriter.registerSessionLayerExporter(MarkerLayer.class, MarkerSessionExporter.class);
        SessionWriter.registerSessionLayerExporter(NoteLayer.class, NoteSessionExporter.class);
    }

    public class ExportSupport {
        private final Document doc;
        private final int layerIndex;

        public ExportSupport(Document doc, int layerIndex) {
            this.doc = doc;
            this.layerIndex = layerIndex;
        }

        public Element createElement(String name) {
            return this.doc.createElement(name);
        }

        public Text createTextNode(String text) {
            return this.doc.createTextNode(text);
        }

        public int getLayerIndex() {
            return this.layerIndex;
        }

        public OutputStream getOutputStreamZip(String zipPath) throws IOException {
            if (!this.isZip()) {
                throw new JosmRuntimeException("not zip");
            }
            ZipEntry entry = new ZipEntry(zipPath);
            SessionWriter.this.zipOut.putNextEntry(entry);
            return SessionWriter.this.zipOut;
        }

        public boolean isZip() {
            return SessionWriter.this.zip;
        }
    }
}

