/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.editor;

import com.ca.commons.cbutil.CBAction;
import com.ca.commons.cbutil.CBBase64;
import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBHelpSystem;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBJComboBox;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBUtility;
import com.ca.directory.jxplorer.editor.abstractbinaryeditor;
import com.ca.directory.jxplorer.editor.editablebinary;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;

public class userpasswordeditor
extends JDialog
implements abstractbinaryeditor {
    public static final String MD5 = "MD5";
    public static final String SHA = "SHA";
    public static final String SSHA = "SSHA";
    public static final String SMD5 = "SMD5";
    protected JPasswordField oldPwd;
    protected JPasswordField newPwd;
    protected CBButton btnOK;
    protected CBButton btnCancel;
    protected CBButton btnHelp;
    protected editablebinary editMe = null;
    protected CBPanel display;
    protected JLabel oldLabel;
    protected JLabel newLabel;
    protected CBJComboBox comboType;
    protected boolean firstClick = true;
    protected static int default_encryption = 4;
    private static Logger log = Logger.getLogger(userpasswordeditor.class.getName());

    public userpasswordeditor(Frame owner) {
        super(owner);
        this.setModal(true);
        this.setTitle(CBIntText.get("User Password"));
        this.display = new CBPanel();
        this.oldPwd = new JPasswordField();
        this.oldPwd.setBackground(Color.white);
        this.oldPwd.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                if (userpasswordeditor.this.firstClick) {
                    userpasswordeditor.this.oldPwd.setText("");
                    userpasswordeditor.this.firstClick = false;
                }
            }
        });
        this.newPwd = new JPasswordField();
        this.newPwd.setBackground(Color.white);
        this.oldLabel = new JLabel(CBIntText.get("Enter Password:"));
        this.newLabel = new JLabel(CBIntText.get("Re-enter Password:"));
        this.btnOK = new CBButton(CBIntText.get("OK"), CBIntText.get("Click here to save the changes (remember to click Submit in the table editor)."));
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                userpasswordeditor.this.load();
            }
        });
        this.btnCancel = new CBButton(CBIntText.get("Cancel"), CBIntText.get("Click here to exit."));
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                userpasswordeditor.this.quit();
            }
        });
        this.comboType = new CBJComboBox();
        this.comboType.addItem(CBIntText.get("verify"));
        this.comboType.addItem(CBIntText.get("plain"));
        this.comboType.addItem(CBIntText.get(MD5));
        this.comboType.addItem(CBIntText.get(SMD5));
        this.comboType.addItem(CBIntText.get(SHA));
        this.comboType.addItem(CBIntText.get(SSHA));
        this.comboType.setEditable(false);
        this.comboType.setSelectedIndex(default_encryption);
        this.comboType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (userpasswordeditor.this.comboType.getSelectedIndex() == 0) {
                    userpasswordeditor.this.setNewPwdFieldEnabled(false);
                } else {
                    userpasswordeditor.this.setNewPwdFieldEnabled(true);
                }
            }
        });
        this.comboType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                default_encryption = userpasswordeditor.this.comboType.getSelectedIndex();
            }
        });
        this.btnHelp = new CBButton(CBIntText.get("Help"), CBIntText.get("Click here for Help."));
        CBHelpSystem.useDefaultHelp(this.btnHelp, "attr.password");
        this.display.makeHeavy();
        this.display.addln(this.oldLabel);
        this.display.addln(this.oldPwd);
        this.display.addln(this.newLabel);
        this.display.addln(this.newPwd);
        this.display.add(this.comboType);
        this.display.addln(new JLabel(" "));
        this.display.makeLight();
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.btnOK);
        buttonPanel.add(this.btnCancel);
        buttonPanel.add(this.btnHelp);
        this.display.addln(buttonPanel);
        this.display.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "enter");
        this.display.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "escape");
        this.display.getActionMap().put("enter", new MyAction(10));
        this.display.getActionMap().put("escape", new MyAction(27));
        this.setSize(300, 170);
        CBUtility.center(this, owner);
        this.setTitle(CBIntText.get("User Password Data"));
        this.getContentPane().add(this.display);
        if (this.comboType.getSelectedIndex() == 0) {
            this.setNewPwdFieldEnabled(false);
        } else {
            this.setNewPwdFieldEnabled(true);
        }
    }

    protected void setNewPwdFieldEnabled(boolean enabled) {
        this.newPwd.setFocusable(enabled);
        this.newPwd.setEnabled(enabled);
        this.newLabel.setEnabled(enabled);
        if (enabled) {
            this.newPwd.setBackground(Color.white);
        } else {
            this.newPwd.setBackground(Color.lightGray);
        }
    }

    public void setValue(editablebinary editMe) {
        this.editMe = editMe;
        this.oldPwd.setText(this.stringEncode(editMe.getValue()));
    }

    protected byte[] plainDecode(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.WARNING, "Unexpected error encoding password ", e);
            e.printStackTrace();
            return new byte[0];
        }
    }

    protected byte[] mdDecode(String s, int type, byte[] salt) {
        try {
            MessageDigest md;
            StringBuffer hexString = new StringBuffer();
            if (type == 5 && salt != null) {
                md = MessageDigest.getInstance(SHA);
                hexString.append("{SSHA}");
            } else if (type == 4) {
                md = MessageDigest.getInstance(SHA);
                hexString.append("{SHA}");
            } else if (type == 3 && salt != null) {
                md = MessageDigest.getInstance(MD5);
                hexString.append("{SMD5}");
            } else if (type == 2) {
                md = MessageDigest.getInstance(MD5);
                hexString.append("{MD5}");
            } else {
                return null;
            }
            md.reset();
            md.update(s.getBytes("UTF-8"));
            if (salt != null) {
                int x;
                md.update(salt);
                byte[] buff = md.digest();
                byte[] new_buf = new byte[buff.length + salt.length];
                for (x = 0; x < buff.length; ++x) {
                    new_buf[x] = buff[x];
                }
                for (x = buff.length; x < new_buf.length; ++x) {
                    new_buf[x] = salt[x - buff.length];
                }
                hexString.append(CBBase64.binaryToString(new_buf));
            } else {
                byte[] buff = md.digest();
                hexString.append(CBBase64.binaryToString(buff));
            }
            return hexString.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.WARNING, "Unexpected error encoding password ", e);
            e.printStackTrace();
            return new byte[0];
        }
        catch (NoSuchAlgorithmException e) {
            log.log(Level.WARNING, "Unexpected error encoding password ", e);
            e.printStackTrace();
            return new byte[0];
        }
    }

    protected byte[] stringDecode(String s, byte[] salt) {
        if (s == null) {
            return new byte[0];
        }
        switch (this.comboType.getSelectedIndex()) {
            case 1: {
                return this.plainDecode(s);
            }
            case 2: {
                return this.mdDecode(s, 2, null);
            }
            case 3: {
                return this.mdDecode(s, 3, salt);
            }
            case 4: {
                return this.mdDecode(s, 4, null);
            }
            case 5: {
                return this.mdDecode(s, 5, salt);
            }
        }
        return this.mdDecode(s, 4, null);
    }

    protected String stringEncode(byte[] b) {
        if (b == null || b.length == 0) {
            return new String();
        }
        try {
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.WARNING, "Unexpected error decoding password ", e);
            e.printStackTrace();
            return new String(b);
        }
    }

    protected void load() {
        if (this.comboType.getSelectedIndex() == 0) {
            String msg_1 = CBIntText.get("Password not verified.");
            String msg_2 = CBIntText.get("Password Verification.");
            String nPwd = new String(this.oldPwd.getPassword());
            String oPwd = this.stringEncode(this.editMe.getValue());
            if (this.passwordVerify(oPwd, nPwd)) {
                msg_1 = CBIntText.get("Password verified.");
            }
            JOptionPane.showMessageDialog(this.display, msg_1, msg_2, 1);
        } else if (this.passwordConfirm()) {
            byte[] salt = null;
            if (this.comboType.getSelectedIndex() == 3 || this.comboType.getSelectedIndex() == 5) {
                try {
                    SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
                    salt = new byte[8];
                    random.nextBytes(salt);
                }
                catch (NoSuchAlgorithmException e) {
                    log.log(Level.WARNING, "Unexpected error encoding password ", e);
                    e.printStackTrace();
                    return;
                }
            }
            this.editMe.setValue(this.stringDecode(new String(this.newPwd.getPassword()), salt));
            this.quit();
        }
    }

    protected boolean passwordVerify(String oPwd, String nPwd) {
        if (oPwd.startsWith("{MD5}")) {
            nPwd = new String(this.mdDecode(nPwd, 2, null));
        } else if (oPwd.startsWith("{SMD5}")) {
            int len;
            byte[] tmp = CBBase64.stringToBinary(oPwd.substring(6));
            if (tmp != null && (len = tmp.length - 16) > 0) {
                byte[] salt = new byte[len];
                for (int x = 0; x < len; ++x) {
                    salt[x] = tmp[x + 16];
                }
                nPwd = new String(this.mdDecode(nPwd, 3, salt));
            }
        } else if (oPwd.startsWith("{SHA}")) {
            nPwd = new String(this.mdDecode(nPwd, 4, null));
        } else if (oPwd.startsWith("{SSHA}")) {
            int len;
            byte[] tmp = CBBase64.stringToBinary(oPwd.substring(6));
            if (tmp != null && (len = tmp.length - 20) > 0) {
                byte[] salt = new byte[len];
                for (int x = 0; x < len; ++x) {
                    salt[x] = tmp[x + 20];
                }
                nPwd = new String(this.mdDecode(nPwd, 5, salt));
            }
        } else {
            nPwd = new String(this.plainDecode(nPwd));
        }
        return nPwd.equals(oPwd);
    }

    protected boolean passwordConfirm() {
        if (new String(this.newPwd.getPassword()).equals(new String(this.oldPwd.getPassword()))) {
            return true;
        }
        if (new String(this.newPwd.getPassword()).equals("")) {
            JOptionPane.showMessageDialog(this.display, CBIntText.get("Empty password field, please fill in both fields"), CBIntText.get("Warning message"), 1);
            this.newPwd.setText("");
            return false;
        }
        JOptionPane.showMessageDialog(this.display, CBIntText.get("Password typed incorrectly, please try again"), CBIntText.get("Warning message"), 1);
        this.newPwd.setText("");
        return false;
    }

    protected void quit() {
        this.setVisible(false);
        this.dispose();
    }

    private class MyAction
    extends CBAction {
        public MyAction(int key) {
            super(key);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.getKey() == 27) {
                userpasswordeditor.this.quit();
            } else if (this.getKey() == 10) {
                userpasswordeditor.this.load();
            }
        }
    }
}

