/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.tree;

import com.ca.commons.cbutil.CBResourceLoader;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.RDN;
import com.ca.directory.jxplorer.JXplorer;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class SmartNode
extends DefaultMutableTreeNode
implements Transferable,
Comparable {
    private static RDN emptyRDN = new RDN();
    public RDN rdn = emptyRDN;
    String nodeObjectClass = null;
    boolean dummy = false;
    boolean root = false;
    boolean alwaysRefresh = false;
    boolean blankRoot = false;
    boolean structural = false;
    static Hashtable icons = new Hashtable(16);
    static boolean useIcons;
    public static final String ROOTNAME = "World";
    public static final String DUMMYMESSAGE = "reading...";
    ImageIcon icon = null;
    JPopupMenu menu = null;
    private static boolean initialised;
    public static final DataFlavor UNICODETEXT;
    DataFlavor[] flavours = new DataFlavor[]{UNICODETEXT};
    private static Collator myCollator;
    private CollationKey collationKey;
    private static Logger log;

    public static void init(CBResourceLoader resourceLoader) {
        if (initialised) {
            return;
        }
        initialised = true;
        String iconPath = JXplorer.getProperty("dir.icons");
        if (iconPath == null) {
            useIcons = false;
            return;
        }
        String[] extensions = new String[]{"jpg", "gif", "jpeg"};
        String[] iconFiles = CBUtility.readFilteredDirectory(iconPath, extensions);
        if (iconFiles == null) {
            log.warning("can't find icon directory " + iconPath + " trying to find /icons directory");
            iconPath = JXplorer.localDir + "icons" + File.separator;
            iconFiles = CBUtility.readFilteredDirectory(iconPath, extensions);
            if (iconFiles == null) {
                log.warning("Can't find icon directory; check 'dir.icons=' line in dxconfig.txt.");
                return;
            }
            log.warning("Recovered!  - iconPath reset to " + iconPath);
            JXplorer.myProperties.setProperty("dir.icons", iconPath);
        }
        for (int i = 0; i < iconFiles.length; ++i) {
            String stem = iconFiles[i].substring(0, iconFiles[i].lastIndexOf(46));
            icons.put(stem.toLowerCase(), new ImageIcon(iconPath + iconFiles[i]));
        }
        try {
            String[] extraIcons = resourceLoader.getPrefixedResources("icons/");
            for (int i = 0; i < extraIcons.length; ++i) {
                String iconName = extraIcons[i];
                String stem = iconName.substring(6);
                int endpos = stem.lastIndexOf(46);
                if (stem.length() <= 0 || endpos == -1) continue;
                stem = stem.substring(0, endpos).toLowerCase();
                byte[] b = resourceLoader.getResource(iconName);
                icons.put(stem, new ImageIcon(b));
            }
        }
        catch (Exception e) {
            log.warning("Error trying to load icons from resource files: " + e);
        }
        useIcons = icons.containsKey("default");
    }

    public SmartNode() {
        log.finer("created null SmartNode (I)");
        this.dummy = true;
        this.nodeObjectClass = "default";
    }

    public SmartNode(String rdnString) {
        log.finer("created SmartNode (II) :" + rdnString);
        this.update(rdnString);
    }

    public SmartNode(RDN rdn) {
        log.finer("created SmartNode (IIb) :" + rdn);
        this.update(rdn);
    }

    public SmartNode(SmartNode S) {
        log.finer("created SmartNode (III) :" + S.toString());
        this.nodeObjectClass = new String(S.nodeObjectClass);
        this.icon = S.icon;
        this.update(S.getRDN());
        this.dummy = S.dummy;
    }

    public SmartNode(String RDN2, DXAttribute objectClasses) {
        log.finer("created SmartNode (IV) :" + RDN2);
        this.update(RDN2);
        this.setTrueObjectClass(objectClasses);
    }

    public void setTrueObjectClass(DXAttribute objectClasses) {
        try {
            String value;
            NamingEnumeration<?> obClasses = objectClasses.getAll();
            while (obClasses.hasMoreElements() && !this.setTrueObjectClass(value = obClasses.nextElement().toString())) {
            }
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "Naming Exception parsing " + this.rdn + "\n", e);
        }
    }

    public boolean setTrueObjectClass(String value) {
        if (icons.containsKey(value = value.toLowerCase())) {
            this.nodeObjectClass = value;
            this.icon = (ImageIcon)icons.get(this.nodeObjectClass);
            return true;
        }
        return false;
    }

    public void update(String rdn) {
        try {
            this.update(new RDN(rdn));
        }
        catch (Exception e) {
            log.warning("unexpected error in SmartNode:update() " + e.toString());
            e.printStackTrace();
        }
    }

    public void update(RDN newRDN) {
        if (newRDN == null) {
            this.setRdn(emptyRDN);
        } else {
            this.setRdn(newRDN);
        }
        if (this.rdn.isEmpty()) {
            this.nodeObjectClass = "default";
        }
        if (this.nodeObjectClass == null) {
            this.nodeObjectClass = this.rdn.getAtt(0);
        }
        boolean sortByNamingAttribute = "true".equals(JXplorer.getProperty("sort.by.naming.attribute"));
        if (this.rdn.isMultiValued()) {
            StringBuffer key = new StringBuffer(this.rdn.toString().length());
            for (int i = 0; i < this.rdn.size(); ++i) {
                if (sortByNamingAttribute) {
                    key.append(this.rdn.getRawVal(i)).append(this.rdn.getAtt(i));
                    continue;
                }
                key.append(this.rdn.getAtt(i)).append(this.rdn.getRawVal(i));
            }
            this.collationKey = myCollator.getCollationKey(key.toString().toLowerCase());
        } else {
            this.collationKey = sortByNamingAttribute ? myCollator.getCollationKey(this.nodeObjectClass + this.getDistinguishedValue().toLowerCase()) : myCollator.getCollationKey(this.getDistinguishedValue().toLowerCase() + this.nodeObjectClass);
        }
    }

    public void copyChildren(Enumeration children) {
        while (children.hasMoreElements()) {
            SmartNode A = new SmartNode((SmartNode)children.nextElement());
            this.add(A);
        }
    }

    public RDN getRDN() {
        return this.blankRoot ? emptyRDN : this.rdn;
    }

    public String toString() {
        if (this.blankRoot) {
            return ROOTNAME;
        }
        if (this.dummy) {
            return DUMMYMESSAGE;
        }
        return this.rdn.toString();
    }

    public String getObjectClass() {
        return this.nodeObjectClass;
    }

    public String getDistinguishedValue() {
        if (this.rdn.isMultiValued()) {
            int size = this.rdn.size();
            StringBuffer val = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    val.append("  +  ");
                }
                val.append(this.rdn.getRawVal(i));
            }
            return val.toString();
        }
        return this.rdn.getRawVal(0);
    }

    public String getIconName() {
        return this.nodeObjectClass;
    }

    public boolean isDummy() {
        return this.dummy;
    }

    public boolean hasDummy() {
        if (this.getChildCount() == 0) {
            return false;
        }
        return ((SmartNode)this.getChildAt(0)).isDummy();
    }

    public String getDummyMessage() {
        return DUMMYMESSAGE;
    }

    public boolean isRoot() {
        return this.root;
    }

    public boolean isBlankRoot() {
        return this.blankRoot;
    }

    public String getBlankRootName() {
        return ROOTNAME;
    }

    public boolean isAlwaysRefresh() {
        return this.alwaysRefresh;
    }

    public void setAlwaysRefresh(boolean state) {
        this.alwaysRefresh = state;
    }

    public void setRoot(boolean state) {
        this.root = state;
        this.blankRoot = false;
        if (this.root && "".equals(this.rdn.toString())) {
            this.update("");
            this.blankRoot = true;
            this.nodeObjectClass = ROOTNAME.toLowerCase();
        }
    }

    public ImageIcon getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        this.icon = (ImageIcon)icons.get(this.nodeObjectClass.toLowerCase());
        if (this.icon == null) {
            this.icon = (ImageIcon)icons.get("default");
        }
        return this.icon;
    }

    public void setIcon(ImageIcon newIcon) {
        this.icon = newIcon;
    }

    public boolean hasChild(SmartNode n) {
        return this.hasChild(n.toString());
    }

    public boolean hasChild(RDN r) {
        return this.hasChild(r.toString());
    }

    public boolean hasChild(String testRDN) {
        Enumeration<TreeNode> children = this.children();
        while (children.hasMoreElements()) {
            if (!testRDN.equalsIgnoreCase(children.nextElement().toString())) continue;
            return true;
        }
        return false;
    }

    public boolean isStructural() {
        return this.structural;
    }

    public void setStructural(boolean val) {
        this.structural = val;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (o == null) {
            return -1;
        }
        if (((SmartNode)o).collationKey == null) {
            return -1;
        }
        if (this.collationKey == null) {
            return 1;
        }
        return this.collationKey.compareTo(((SmartNode)o).collationKey);
    }

    public void sort() {
        TreeSet<TreeNode> sortedSet = new TreeSet<TreeNode>();
        Enumeration<TreeNode> kids = this.children();
        while (kids.hasMoreElements()) {
            TreeNode kid = kids.nextElement();
            sortedSet.add(kid);
        }
        this.removeAllChildren();
        Iterator sortedKids = sortedSet.iterator();
        while (sortedKids.hasNext()) {
            SmartNode newNode = (SmartNode)sortedKids.next();
            this.add(newNode);
        }
    }

    public boolean rdnEquals(RDN testRDN) {
        return testRDN.equals(this.rdn);
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.menu = popupMenu;
    }

    public JPopupMenu getPopupMenu() {
        return this.menu;
    }

    public boolean isMultiValued() {
        return this.rdn.isMultiValued();
    }

    public DN getDN() {
        if (this.root) {
            return new DN();
        }
        DN ret = ((SmartNode)this.getParent()).getDN();
        ret.add(this.getRDN());
        return ret;
    }

    public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
        if (!df.equals(this.flavours[0])) {
            throw new UnsupportedFlavorException(df);
        }
        String dn = this.getDN().toString();
        return dn;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavours;
    }

    public boolean isDataFlavorSupported(DataFlavor flavour) {
        for (int i = 0; i < this.flavours.length; ++i) {
            if (!this.flavours[i].equals(flavour)) continue;
            return true;
        }
        return false;
    }

    public void setRdn(RDN rdn) {
        this.rdn = rdn;
    }

    static {
        initialised = false;
        UNICODETEXT = DataFlavor.getTextPlainUnicodeFlavor();
        myCollator = Collator.getInstance();
        log = Logger.getLogger(SmartNode.class.getName());
    }
}

