/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.webauthn4j.converter.jackson.JacksonUtil;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CoreRegistrationObject {
    private static final ObjectMapper cborMapper = new ObjectMapper((JsonFactory)new CBORFactory());
    private final AttestationObject attestationObject;
    private final byte[] attestationObjectBytes;
    private final byte[] clientDataHash;
    private final CoreServerProperty serverProperty;
    private final Instant timestamp;

    public CoreRegistrationObject(@NonNull AttestationObject attestationObject, @NonNull byte[] attestationObjectBytes, @NonNull byte[] clientDataHash, @NonNull CoreServerProperty serverProperty, @NonNull Instant timestamp) {
        AssertUtil.notNull((Object)attestationObject, (String)"attestationObject must not be null");
        AssertUtil.notNull((Object)attestationObjectBytes, (String)"attestationObjectBytes must not be null");
        AssertUtil.notNull((Object)clientDataHash, (String)"clientDataHash must not be null");
        AssertUtil.notNull((Object)serverProperty, (String)"serverProperty must not be null");
        AssertUtil.notNull((Object)timestamp, (String)"timestamp must not be null");
        this.attestationObject = attestationObject;
        this.attestationObjectBytes = attestationObjectBytes;
        this.clientDataHash = clientDataHash;
        this.serverProperty = serverProperty;
        this.timestamp = timestamp;
    }

    public CoreRegistrationObject(@NonNull AttestationObject attestationObject, @NonNull byte[] attestationObjectBytes, @NonNull byte[] clientDataHash, @NonNull CoreServerProperty serverProperty) {
        this(attestationObject, attestationObjectBytes, clientDataHash, serverProperty, Instant.now());
    }

    private static @NonNull byte[] extractAuthenticatorData(@NonNull byte[] attestationObject) {
        return JacksonUtil.binaryValue(JacksonUtil.readTree(cborMapper, attestationObject).get("authData"));
    }

    public @NonNull AttestationObject getAttestationObject() {
        return this.attestationObject;
    }

    public @NonNull byte[] getAttestationObjectBytes() {
        return ArrayUtil.clone((byte[])this.attestationObjectBytes);
    }

    public @NonNull byte[] getAuthenticatorDataBytes() {
        return CoreRegistrationObject.extractAuthenticatorData(this.attestationObjectBytes);
    }

    public @NonNull byte[] getClientDataHash() {
        return this.clientDataHash;
    }

    public @NonNull CoreServerProperty getServerProperty() {
        return this.serverProperty;
    }

    public @NonNull Instant getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreRegistrationObject that = (CoreRegistrationObject)o;
        return Objects.equals(this.attestationObject, that.attestationObject) && Arrays.equals(this.attestationObjectBytes, that.attestationObjectBytes) && Arrays.equals(this.clientDataHash, that.clientDataHash) && Objects.equals(this.serverProperty, that.serverProperty) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        int result = Objects.hash(this.attestationObject, this.serverProperty, this.timestamp);
        result = 31 * result + Arrays.hashCode(this.attestationObjectBytes);
        result = 31 * result + Arrays.hashCode(this.clientDataHash);
        return result;
    }
}

