/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.sql.FromClauseIndex;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.sql.results.internal.RowTransformerArrayImpl;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.jboss.logging.Logger;

class DatabaseSnapshotExecutor {
    private static final Logger log = Logger.getLogger(DatabaseSnapshotExecutor.class);
    private final EntityMappingType entityDescriptor;
    private final JdbcOperationQuerySelect jdbcSelect;
    private final JdbcParametersList jdbcParameters;

    DatabaseSnapshotExecutor(EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        JdbcParametersList.Builder jdbcParametersBuilder = JdbcParametersList.newBuilder(entityDescriptor.getIdentifierMapping().getJdbcTypeCount());
        QuerySpec rootQuerySpec = new QuerySpec(true);
        SqlAliasBaseManager sqlAliasBaseManager = new SqlAliasBaseManager();
        LoaderSqlAstCreationState state = new LoaderSqlAstCreationState(rootQuerySpec, sqlAliasBaseManager, new FromClauseIndex(null), LockOptions.NONE, (fetchParent, creationState) -> ImmutableFetchList.EMPTY, true, new LoadQueryInfluencers(sessionFactory), sessionFactory);
        NavigablePath rootPath = new NavigablePath(entityDescriptor.getEntityName());
        TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(true, rootPath, null, null, () -> rootQuerySpec::applyPredicate, state);
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        state.getFromClauseAccess().registerTableGroup(rootPath, rootTableGroup);
        ArrayList domainResults = new ArrayList();
        SqlExpressionResolver sqlExpressionResolver = state.getSqlExpressionResolver();
        BasicType<Integer> resolved = sessionFactory.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER);
        QueryLiteral<Object> queryLiteral = new QueryLiteral<Object>(null, resolved);
        domainResults.add(queryLiteral.createDomainResult(null, state));
        NavigablePath idNavigablePath = rootPath.append(entityDescriptor.getIdentifierMapping().getNavigableRole().getNavigableName());
        entityDescriptor.getIdentifierMapping().forEachSelectable((columnIndex, selection) -> {
            TableReference tableReference = rootTableGroup.resolveTableReference(idNavigablePath, selection.getContainingTableExpression());
            JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(selection.getJdbcMapping());
            jdbcParametersBuilder.add(jdbcParameter);
            ColumnReference columnReference = (ColumnReference)sqlExpressionResolver.resolveSqlExpression(tableReference, selection);
            rootQuerySpec.applyPredicate(new ComparisonPredicate(columnReference, ComparisonOperator.EQUAL, jdbcParameter));
        });
        this.jdbcParameters = jdbcParametersBuilder.build();
        entityDescriptor.forEachAttributeMapping(attributeMapping -> {
            NavigablePath navigablePath = rootPath.append(attributeMapping.getAttributeName());
            DomainResult snapshotDomainResult = attributeMapping.createSnapshotDomainResult(navigablePath, rootTableGroup, null, state);
            if (snapshotDomainResult != null) {
                domainResults.add(snapshotDomainResult);
            }
        });
        SelectStatement selectStatement = new SelectStatement(rootQuerySpec, domainResults);
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        this.jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, selectStatement).translate(null, QueryOptions.NONE);
    }

    Object[] loadDatabaseSnapshot(Object id, SharedSessionContractImplementor session) {
        if (log.isTraceEnabled()) {
            log.tracef("Getting current persistent state for `%s#%s`", (Object)this.entityDescriptor.getEntityName(), id);
        }
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(this.entityDescriptor.getIdentifierMapping().getJdbcTypeCount());
        int offset = jdbcParameterBindings.registerParametersForEachJdbcValue(id, this.entityDescriptor.getIdentifierMapping(), this.jdbcParameters, session);
        assert (offset == this.jdbcParameters.size());
        List<Object[]> list = session.getJdbcServices().getJdbcSelectExecutor().list(this.jdbcSelect, jdbcParameterBindings, new BaseExecutionContext(session), RowTransformerArrayImpl.instance(), null, ListResultsConsumer.UniqueSemantic.FILTER, 1);
        int size = list.size();
        assert (size <= 1);
        if (size == 0) {
            return null;
        }
        Object[] entitySnapshot = list.get(0);
        if (entitySnapshot.length == 1) {
            return ArrayHelper.EMPTY_OBJECT_ARRAY;
        }
        Object[] state = new Object[entitySnapshot.length - 1];
        System.arraycopy(entitySnapshot, 1, state, 0, state.length);
        return state;
    }
}

