/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.quarkus.arc.ArcInvocationContext;
import io.quarkus.micrometer.runtime.MeterTagsSupport;
import io.quarkus.micrometer.runtime.MicrometerCounted;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.TypesUtil;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.tuples.Functions;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import java.lang.reflect.Method;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;

@Interceptor
@MicrometerCounted
@Priority(value=1010)
public class MicrometerCountedInterceptor {
    public final String RESULT_TAG_FAILURE_VALUE = "failure";
    public final String RESULT_TAG_SUCCESS_VALUE = "success";
    private final MeterRegistry meterRegistry;
    private final MeterTagsSupport meterTagsSupport;

    public MicrometerCountedInterceptor(MeterRegistry meterRegistry, MeterTagsSupport meterTagsSupport) {
        this.meterRegistry = meterRegistry;
        this.meterTagsSupport = meterTagsSupport;
    }

    @AroundInvoke
    Object countedMethod(ArcInvocationContext context) throws Exception {
        final MicrometerCounted counted = (MicrometerCounted)context.findIterceptorBinding(MicrometerCounted.class);
        if (counted == null) {
            return context.proceed();
        }
        Method method = context.getMethod();
        final Tags tags = this.meterTagsSupport.getTags(context);
        Class<?> returnType = method.getReturnType();
        if (TypesUtil.isCompletionStage(returnType)) {
            try {
                return ((CompletionStage)context.proceed()).whenComplete(new BiConsumer<Object, Throwable>(){

                    @Override
                    public void accept(Object o, Throwable throwable) {
                        MicrometerCountedInterceptor.this.recordCompletionResult(counted, tags, throwable);
                    }
                });
            }
            catch (Throwable e) {
                this.record(counted, tags, e);
            }
        } else if (TypesUtil.isUni(returnType)) {
            try {
                return ((Uni)context.proceed()).onTermination().invoke((Functions.TriConsumer)new Functions.TriConsumer<Object, Throwable, Boolean>(){

                    public void accept(Object o, Throwable throwable, Boolean cancelled) {
                        MicrometerCountedInterceptor.this.recordCompletionResult(counted, tags, throwable);
                    }
                });
            }
            catch (Throwable e) {
                this.record(counted, tags, e);
            }
        }
        try {
            Object result = context.proceed();
            if (!counted.recordFailuresOnly()) {
                this.record(counted, tags, null);
            }
            return result;
        }
        catch (Throwable e) {
            this.record(counted, tags, e);
            throw e;
        }
    }

    private void recordCompletionResult(MicrometerCounted counted, Tags commonTags, Throwable throwable) {
        if (throwable != null) {
            this.record(counted, commonTags, throwable);
        } else if (!counted.recordFailuresOnly()) {
            this.record(counted, commonTags, null);
        }
    }

    private void record(MicrometerCounted counted, Tags commonTags, Throwable throwable) {
        Counter.Builder builder = Counter.builder((String)counted.value()).tags((Iterable)commonTags).tags(counted.extraTags()).tag("exception", MicrometerRecorder.getExceptionTag(throwable)).tag("result", throwable == null ? "success" : "failure");
        String description = counted.description();
        if (!description.isEmpty()) {
            builder.description(description);
        }
        builder.register(this.meterRegistry).increment();
    }
}

