/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.configuration.TrimmedStringConverter;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import java.util.Map;
import java.util.Optional;
import org.hibernate.FlushMode;

@ConfigGroup
public interface HibernateOrmRuntimeConfigPersistenceUnit {
    @ConfigDocDefault(value="'true' if Hibernate ORM is enabled; 'false' otherwise")
    public Optional<Boolean> active();

    @ConfigDocSection
    public HibernateOrmConfigPersistenceUnitDatabase database();

    @ConfigDocSection
    public HibernateOrmConfigPersistenceUnitScripts scripts();

    @ConfigDocSection
    public HibernateOrmConfigPersistenceUnitLog log();

    @ConfigDocSection
    public HibernateOrmConfigPersistenceUnitFlush flush();

    @ConfigDocMapKey(value="full-property-key")
    public Map<String, String> unsupportedProperties();

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitFlush {
        @WithDefault(value="auto")
        public FlushMode mode();
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitLog {
        @WithDefault(value="false")
        public boolean sql();

        @WithDefault(value="true")
        public boolean formatSql();

        @WithDefault(value="true")
        public boolean highlightSql();

        @ConfigDocDefault(value="depends on dialect")
        public Optional<Boolean> jdbcWarnings();

        public Optional<Long> queriesSlowerThanMs();
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitScriptGeneration {
        @WithParentName
        @WithDefault(value="none")
        @WithConverter(value=TrimmedStringConverter.class)
        public String generation();

        @WithConverter(value=TrimmedStringConverter.class)
        public Optional<String> createTarget();

        @WithConverter(value=TrimmedStringConverter.class)
        public Optional<String> dropTarget();
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitDatabaseGeneration {
        @WithParentName
        @WithDefault(value="none")
        @WithConverter(value=TrimmedStringConverter.class)
        public String generation();

        @WithDefault(value="false")
        public boolean createSchemas();

        @WithDefault(value="false")
        public boolean haltOnError();
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitScripts {
        public HibernateOrmConfigPersistenceUnitScriptGeneration generation();
    }

    @ConfigGroup
    public static interface HibernateOrmConfigPersistenceUnitDatabase {
        public HibernateOrmConfigPersistenceUnitDatabaseGeneration generation();

        @WithConverter(value=TrimmedStringConverter.class)
        public Optional<String> defaultCatalog();

        @WithConverter(value=TrimmedStringConverter.class)
        public Optional<String> defaultSchema();

        @WithName(value="version-check.enabled")
        @ConfigDocDefault(value="`true` if the dialect was set automatically by Quarkus, `false` if it was set explicitly")
        public Optional<Boolean> versionCheckEnabled();
    }
}

