/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkAccelerationStructureInstanceKHR;
import org.lwjgl.vulkan.VkTransformMatrixKHR;

public class VkAccelerationStructureInstanceNV
extends VkAccelerationStructureInstanceKHR {
    public VkAccelerationStructureInstanceNV(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkAccelerationStructureInstanceNV transform(VkTransformMatrixKHR value) {
        VkAccelerationStructureInstanceNV.ntransform(this.address(), value);
        return this;
    }

    @Override
    public VkAccelerationStructureInstanceNV transform(Consumer<VkTransformMatrixKHR> consumer) {
        consumer.accept(this.transform());
        return this;
    }

    @Override
    public VkAccelerationStructureInstanceNV instanceCustomIndex(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureInstanceNV.ninstanceCustomIndex(this.address(), value);
        return this;
    }

    @Override
    public VkAccelerationStructureInstanceNV mask(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureInstanceNV.nmask(this.address(), value);
        return this;
    }

    @Override
    public VkAccelerationStructureInstanceNV instanceShaderBindingTableRecordOffset(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureInstanceNV.ninstanceShaderBindingTableRecordOffset(this.address(), value);
        return this;
    }

    @Override
    public VkAccelerationStructureInstanceNV flags(@NativeType(value="VkGeometryInstanceFlagsKHR") int value) {
        VkAccelerationStructureInstanceNV.nflags(this.address(), value);
        return this;
    }

    @Override
    public VkAccelerationStructureInstanceNV accelerationStructureReference(@NativeType(value="uint64_t") long value) {
        VkAccelerationStructureInstanceNV.naccelerationStructureReference(this.address(), value);
        return this;
    }

    @Override
    public VkAccelerationStructureInstanceNV set(VkTransformMatrixKHR transform, int instanceCustomIndex, int mask, int instanceShaderBindingTableRecordOffset, int flags, long accelerationStructureReference) {
        this.transform(transform);
        this.instanceCustomIndex(instanceCustomIndex);
        this.mask(mask);
        this.instanceShaderBindingTableRecordOffset(instanceShaderBindingTableRecordOffset);
        this.flags(flags);
        this.accelerationStructureReference(accelerationStructureReference);
        return this;
    }

    public VkAccelerationStructureInstanceNV set(VkAccelerationStructureInstanceNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkAccelerationStructureInstanceNV malloc() {
        return (VkAccelerationStructureInstanceNV)VkAccelerationStructureInstanceNV.wrap(VkAccelerationStructureInstanceNV.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkAccelerationStructureInstanceNV calloc() {
        return (VkAccelerationStructureInstanceNV)VkAccelerationStructureInstanceNV.wrap(VkAccelerationStructureInstanceNV.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkAccelerationStructureInstanceNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkAccelerationStructureInstanceNV)VkAccelerationStructureInstanceNV.wrap(VkAccelerationStructureInstanceNV.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkAccelerationStructureInstanceNV create(long address) {
        return (VkAccelerationStructureInstanceNV)VkAccelerationStructureInstanceNV.wrap(VkAccelerationStructureInstanceNV.class, (long)address);
    }

    @Nullable
    public static VkAccelerationStructureInstanceNV createSafe(long address) {
        return address == 0L ? null : (VkAccelerationStructureInstanceNV)VkAccelerationStructureInstanceNV.wrap(VkAccelerationStructureInstanceNV.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkAccelerationStructureInstanceNV.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkAccelerationStructureInstanceNV.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkAccelerationStructureInstanceNV.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureInstanceNV.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkAccelerationStructureInstanceNV.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkAccelerationStructureInstanceNV.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkAccelerationStructureInstanceNV.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkAccelerationStructureInstanceNV malloc(MemoryStack stack) {
        return (VkAccelerationStructureInstanceNV)VkAccelerationStructureInstanceNV.wrap(VkAccelerationStructureInstanceNV.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAccelerationStructureInstanceNV calloc(MemoryStack stack) {
        return (VkAccelerationStructureInstanceNV)VkAccelerationStructureInstanceNV.wrap(VkAccelerationStructureInstanceNV.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkAccelerationStructureInstanceNV.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkAccelerationStructureInstanceNV.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static class Buffer
    extends VkAccelerationStructureInstanceKHR.Buffer {
        private static final VkAccelerationStructureInstanceNV ELEMENT_FACTORY = VkAccelerationStructureInstanceNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkAccelerationStructureInstanceNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer transform(VkTransformMatrixKHR value) {
            VkAccelerationStructureInstanceNV.ntransform(this.address(), value);
            return this;
        }

        @Override
        public Buffer transform(Consumer<VkTransformMatrixKHR> consumer) {
            consumer.accept(this.transform());
            return this;
        }

        @Override
        public Buffer instanceCustomIndex(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureInstanceNV.ninstanceCustomIndex(this.address(), value);
            return this;
        }

        @Override
        public Buffer mask(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureInstanceNV.nmask(this.address(), value);
            return this;
        }

        @Override
        public Buffer instanceShaderBindingTableRecordOffset(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureInstanceNV.ninstanceShaderBindingTableRecordOffset(this.address(), value);
            return this;
        }

        @Override
        public Buffer flags(@NativeType(value="VkGeometryInstanceFlagsKHR") int value) {
            VkAccelerationStructureInstanceNV.nflags(this.address(), value);
            return this;
        }

        @Override
        public Buffer accelerationStructureReference(@NativeType(value="uint64_t") long value) {
            VkAccelerationStructureInstanceNV.naccelerationStructureReference(this.address(), value);
            return this;
        }
    }
}

