/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMTarget {
    public static final int LLVMBigEndian = 0;
    public static final int LLVMLittleEndian = 1;

    protected LLVMTarget() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="LLVMTargetDataRef")
    public static long LLVMGetModuleDataLayout(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetModuleDataLayout;
        if (Checks.CHECKS) {
            Checks.check((long)M);
        }
        return JNI.invokePP((long)M, (long)__functionAddress);
    }

    public static void LLVMSetModuleDataLayout(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMTargetDataRef") long DL) {
        long __functionAddress = Functions.SetModuleDataLayout;
        if (Checks.CHECKS) {
            Checks.check((long)M);
            Checks.check((long)DL);
        }
        JNI.invokePPV((long)M, (long)DL, (long)__functionAddress);
    }

    public static long nLLVMCreateTargetData(long StringRep) {
        long __functionAddress = Functions.CreateTargetData;
        return JNI.invokePP((long)StringRep, (long)__functionAddress);
    }

    @NativeType(value="LLVMTargetDataRef")
    public static long LLVMCreateTargetData(@NativeType(value="char const *") ByteBuffer StringRep) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)StringRep);
        }
        return LLVMTarget.nLLVMCreateTargetData(MemoryUtil.memAddress((ByteBuffer)StringRep));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMTargetDataRef")
    public static long LLVMCreateTargetData(@NativeType(value="char const *") CharSequence StringRep) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(StringRep, true);
            long StringRepEncoded = stack.getPointerAddress();
            long l = LLVMTarget.nLLVMCreateTargetData(StringRepEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMDisposeTargetData(@NativeType(value="LLVMTargetDataRef") long TD) {
        long __functionAddress = Functions.DisposeTargetData;
        if (Checks.CHECKS) {
            Checks.check((long)TD);
        }
        JNI.invokePV((long)TD, (long)__functionAddress);
    }

    public static void LLVMAddTargetLibraryInfo(@NativeType(value="LLVMTargetLibraryInfoRef") long TLI, @NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.AddTargetLibraryInfo;
        if (Checks.CHECKS) {
            Checks.check((long)TLI);
            Checks.check((long)PM);
        }
        JNI.invokePPV((long)TLI, (long)PM, (long)__functionAddress);
    }

    public static long nLLVMCopyStringRepOfTargetData(long TD) {
        long __functionAddress = Functions.CopyStringRepOfTargetData;
        if (Checks.CHECKS) {
            Checks.check((long)TD);
        }
        return JNI.invokePP((long)TD, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String LLVMCopyStringRepOfTargetData(@NativeType(value="LLVMTargetDataRef") long TD) {
        long __result = LLVMTarget.nLLVMCopyStringRepOfTargetData(TD);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="enum LLVMByteOrdering")
    public static int LLVMByteOrder(@NativeType(value="LLVMTargetDataRef") long TD) {
        long __functionAddress = Functions.ByteOrder;
        if (Checks.CHECKS) {
            Checks.check((long)TD);
        }
        return JNI.invokePI((long)TD, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMPointerSize(@NativeType(value="LLVMTargetDataRef") long TD) {
        long __functionAddress = Functions.PointerSize;
        if (Checks.CHECKS) {
            Checks.check((long)TD);
        }
        return JNI.invokePI((long)TD, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMPointerSizeForAS(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="unsigned int") int AS) {
        long __functionAddress = Functions.PointerSizeForAS;
        if (Checks.CHECKS) {
            Checks.check((long)TD);
        }
        return JNI.invokePI((long)TD, (int)AS, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMIntPtrType(@NativeType(value="LLVMTargetDataRef") long TD) {
        long __functionAddress = Functions.IntPtrType;
        if (Checks.CHECKS) {
            Checks.check((long)TD);
        }
        return JNI.invokePP((long)TD, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMIntPtrTypeForAS(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="unsigned int") int AS) {
        long __functionAddress = Functions.IntPtrTypeForAS;
        if (Checks.CHECKS) {
            Checks.check((long)TD);
        }
        return JNI.invokePP((long)TD, (int)AS, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMIntPtrTypeInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMTargetDataRef") long TD) {
        long __functionAddress = Functions.IntPtrTypeInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
            Checks.check((long)TD);
        }
        return JNI.invokePPP((long)C, (long)TD, (long)__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMIntPtrTypeForASInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="unsigned int") int AS) {
        long __functionAddress = Functions.IntPtrTypeForASInContext;
        if (Checks.CHECKS) {
            Checks.check((long)C);
            Checks.check((long)TD);
        }
        return JNI.invokePPP((long)C, (long)TD, (int)AS, (long)__functionAddress);
    }

    @NativeType(value="unsigned long long")
    public static long LLVMSizeOfTypeInBits(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.SizeOfTypeInBits;
        if (Checks.CHECKS) {
            Checks.check((long)TD);
            Checks.check((long)Ty);
        }
        return JNI.invokePPJ((long)TD, (long)Ty, (long)__functionAddress);
    }

    @NativeType(value="unsigned long long")
    public static long LLVMStoreSizeOfType(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.StoreSizeOfType;
        if (Checks.CHECKS) {
            Checks.check((long)TD);
            Checks.check((long)Ty);
        }
        return JNI.invokePPJ((long)TD, (long)Ty, (long)__functionAddress);
    }

    @NativeType(value="unsigned long long")
    public static long LLVMABISizeOfType(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.ABISizeOfType;
        if (Checks.CHECKS) {
            Checks.check((long)TD);
            Checks.check((long)Ty);
        }
        return JNI.invokePPJ((long)TD, (long)Ty, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMABIAlignmentOfType(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.ABIAlignmentOfType;
        if (Checks.CHECKS) {
            Checks.check((long)TD);
            Checks.check((long)Ty);
        }
        return JNI.invokePPI((long)TD, (long)Ty, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMCallFrameAlignmentOfType(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.CallFrameAlignmentOfType;
        if (Checks.CHECKS) {
            Checks.check((long)TD);
            Checks.check((long)Ty);
        }
        return JNI.invokePPI((long)TD, (long)Ty, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMPreferredAlignmentOfType(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.PreferredAlignmentOfType;
        if (Checks.CHECKS) {
            Checks.check((long)TD);
            Checks.check((long)Ty);
        }
        return JNI.invokePPI((long)TD, (long)Ty, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMPreferredAlignmentOfGlobal(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="LLVMValueRef") long GlobalVar) {
        long __functionAddress = Functions.PreferredAlignmentOfGlobal;
        if (Checks.CHECKS) {
            Checks.check((long)TD);
            Checks.check((long)GlobalVar);
        }
        return JNI.invokePPI((long)TD, (long)GlobalVar, (long)__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMElementAtOffset(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="LLVMTypeRef") long StructTy, @NativeType(value="unsigned long long") long Offset) {
        long __functionAddress = Functions.ElementAtOffset;
        if (Checks.CHECKS) {
            Checks.check((long)TD);
            Checks.check((long)StructTy);
        }
        return JNI.invokePPJI((long)TD, (long)StructTy, (long)Offset, (long)__functionAddress);
    }

    @NativeType(value="unsigned long long")
    public static long LLVMOffsetOfElement(@NativeType(value="LLVMTargetDataRef") long TD, @NativeType(value="LLVMTypeRef") long StructTy, @NativeType(value="unsigned int") int Element) {
        long __functionAddress = Functions.OffsetOfElement;
        if (Checks.CHECKS) {
            Checks.check((long)TD);
            Checks.check((long)StructTy);
        }
        return JNI.invokePPJ((long)TD, (long)StructTy, (int)Element, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long GetModuleDataLayout = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetModuleDataLayout");
        public static final long SetModuleDataLayout = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMSetModuleDataLayout");
        public static final long CreateTargetData = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCreateTargetData");
        public static final long DisposeTargetData = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDisposeTargetData");
        public static final long AddTargetLibraryInfo = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMAddTargetLibraryInfo");
        public static final long CopyStringRepOfTargetData = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCopyStringRepOfTargetData");
        public static final long ByteOrder = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMByteOrder");
        public static final long PointerSize = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMPointerSize");
        public static final long PointerSizeForAS = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMPointerSizeForAS");
        public static final long IntPtrType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMIntPtrType");
        public static final long IntPtrTypeForAS = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMIntPtrTypeForAS");
        public static final long IntPtrTypeInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMIntPtrTypeInContext");
        public static final long IntPtrTypeForASInContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMIntPtrTypeForASInContext");
        public static final long SizeOfTypeInBits = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMSizeOfTypeInBits");
        public static final long StoreSizeOfType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMStoreSizeOfType");
        public static final long ABISizeOfType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMABISizeOfType");
        public static final long ABIAlignmentOfType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMABIAlignmentOfType");
        public static final long CallFrameAlignmentOfType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCallFrameAlignmentOfType");
        public static final long PreferredAlignmentOfType = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMPreferredAlignmentOfType");
        public static final long PreferredAlignmentOfGlobal = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMPreferredAlignmentOfGlobal");
        public static final long ElementAtOffset = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMElementAtOffset");
        public static final long OffsetOfElement = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOffsetOfElement");

        private Functions() {
        }
    }
}

