/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.websocket.event;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.io.websocket.event.EventDTO;
import org.openhab.core.io.websocket.event.EventProcessingException;
import org.openhab.core.io.websocket.event.EventWebSocketAdapter;
import org.openhab.core.io.websocket.event.ItemEventUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket
@NonNullByDefault
public class EventWebSocket {
    public static final String WEBSOCKET_EVENT_TYPE = "WebSocketEvent";
    public static final String WEBSOCKET_TOPIC_PREFIX = "openhab/websocket/";
    private static final Type STRING_LIST_TYPE = TypeToken.getParameterized(List.class, (Type[])new Type[]{String.class}).getType();
    private final Logger logger = LoggerFactory.getLogger(EventWebSocket.class);
    private final EventWebSocketAdapter wsAdapter;
    private final Gson gson;
    private final EventPublisher eventPublisher;
    private final ItemEventUtility itemEventUtility;
    private @Nullable Session session;
    private @Nullable RemoteEndpoint remoteEndpoint;
    private String remoteIdentifier = "<unknown>";
    private List<String> typeFilter = List.of();
    private List<String> sourceFilter = List.of();

    public EventWebSocket(Gson gson, EventWebSocketAdapter wsAdapter, ItemEventUtility itemEventUtility, EventPublisher eventPublisher) {
        this.wsAdapter = wsAdapter;
        this.gson = gson;
        this.itemEventUtility = itemEventUtility;
        this.eventPublisher = eventPublisher;
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        this.wsAdapter.unregisterListener(this);
        this.remoteIdentifier = "<unknown>";
        this.session = null;
        this.remoteEndpoint = null;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        RemoteEndpoint remoteEndpoint;
        this.session = session;
        this.remoteEndpoint = remoteEndpoint = session.getRemote();
        this.remoteIdentifier = remoteEndpoint.getInetSocketAddress().toString();
        this.wsAdapter.registerListener(this);
    }

    @OnWebSocketMessage
    public void onText(String message) {
        EventDTO responseEvent;
        RemoteEndpoint remoteEndpoint = this.remoteEndpoint;
        if (this.session == null || remoteEndpoint == null) {
            return;
        }
        try {
            EventDTO eventDTO = (EventDTO)this.gson.fromJson(message, EventDTO.class);
            try {
                if (eventDTO == null) {
                    throw new EventProcessingException("Deserialized event must not be null");
                }
                String type = eventDTO.type;
                if (type == null) {
                    throw new EventProcessingException("Event type must not be null.");
                }
                switch (type) {
                    case "ItemCommandEvent": {
                        Event itemCommandEvent = this.itemEventUtility.createCommandEvent(eventDTO);
                        this.eventPublisher.post(itemCommandEvent);
                        responseEvent = new EventDTO(WEBSOCKET_EVENT_TYPE, "openhab/websocket/response/success", "", null, eventDTO.eventId);
                        break;
                    }
                    case "ItemStateEvent": {
                        Event itemStateEvent = this.itemEventUtility.createStateEvent(eventDTO);
                        this.eventPublisher.post(itemStateEvent);
                        responseEvent = new EventDTO(WEBSOCKET_EVENT_TYPE, "openhab/websocket/response/success", "", null, eventDTO.eventId);
                        break;
                    }
                    case "ItemTimeSeriesEvent": {
                        Event itemTimeseriesEvent = this.itemEventUtility.createTimeSeriesEvent(eventDTO);
                        this.eventPublisher.post(itemTimeseriesEvent);
                        responseEvent = new EventDTO(WEBSOCKET_EVENT_TYPE, "openhab/websocket/response/success", "", null, eventDTO.eventId);
                        break;
                    }
                    case "WebSocketEvent": {
                        if ("openhab/websocket/heartbeat".equals(eventDTO.topic) && "PING".equals(eventDTO.payload)) {
                            responseEvent = new EventDTO(WEBSOCKET_EVENT_TYPE, "openhab/websocket/heartbeat", "PONG", null, eventDTO.eventId);
                            break;
                        }
                        if ("openhab/websocket/filter/type".equals(eventDTO.topic)) {
                            this.typeFilter = Objects.requireNonNullElse((List)this.gson.fromJson(eventDTO.payload, STRING_LIST_TYPE), List.of());
                            this.logger.debug("Setting type filter for connection to {}: {}", (Object)remoteEndpoint.getInetSocketAddress(), this.typeFilter);
                            responseEvent = new EventDTO(WEBSOCKET_EVENT_TYPE, "openhab/websocket/filter/type", eventDTO.payload, null, eventDTO.eventId);
                            break;
                        }
                        if ("openhab/websocket/filter/source".equals(eventDTO.topic)) {
                            this.sourceFilter = Objects.requireNonNullElse((List)this.gson.fromJson(eventDTO.payload, STRING_LIST_TYPE), List.of());
                            this.logger.debug("Setting source filter for connection to {}: {}", (Object)remoteEndpoint.getInetSocketAddress(), this.typeFilter);
                            responseEvent = new EventDTO(WEBSOCKET_EVENT_TYPE, "openhab/websocket/filter/source", eventDTO.payload, null, eventDTO.eventId);
                            break;
                        }
                        throw new EventProcessingException("Invalid topic or payload in WebSocketEvent");
                    }
                    default: {
                        throw new EventProcessingException("Unknown event type '" + eventDTO.type + "'");
                    }
                }
                if (!WEBSOCKET_EVENT_TYPE.equals(type) && responseEvent.eventId == null) {
                    this.logger.trace("Not sending response event {}, because no eventId present.", (Object)responseEvent);
                    return;
                }
            }
            catch (JsonParseException | EventProcessingException e) {
                this.logger.warn("Failed to process deserialized event '{}': {}", (Object)message, (Object)e.getMessage());
                responseEvent = new EventDTO(WEBSOCKET_EVENT_TYPE, "openhab/websocket/response/failed", "Processing error: " + e.getMessage(), null, eventDTO != null ? eventDTO.eventId : "");
            }
        }
        catch (JsonParseException e) {
            this.logger.warn("Could not deserialize '{}'", (Object)message);
            responseEvent = new EventDTO(WEBSOCKET_EVENT_TYPE, "openhab/websocket/response/failed", "Deserialization error: " + e.getMessage(), null, null);
        }
        try {
            this.sendMessage(this.gson.toJson((Object)responseEvent));
        }
        catch (IOException e) {
            this.logger.debug("Failed to send WebSocketResponseEvent event {} to {}: {}", new Object[]{responseEvent, this.remoteIdentifier, e.getMessage()});
        }
    }

    @OnWebSocketError
    public void onError(Session session, Throwable error) {
        if (session != null) {
            session.close();
        }
        String message = error == null ? "<null>" : Objects.requireNonNullElse(error.getMessage(), "<null>");
        this.logger.info("WebSocket error: {}", (Object)message);
        this.onClose(1005, message);
    }

    public void processEvent(Event event) {
        try {
            String source = event.getSource();
            if (!(source != null && this.sourceFilter.contains(event.getSource()) || !this.typeFilter.isEmpty() && !this.typeFilter.contains(event.getType()))) {
                this.sendMessage(this.gson.toJson((Object)new EventDTO(event)));
            }
        }
        catch (IOException e) {
            this.logger.debug("Failed to send event {} to {}: {}", new Object[]{event, this.remoteIdentifier, e.getMessage()});
        }
    }

    private synchronized void sendMessage(String message) throws IOException {
        RemoteEndpoint remoteEndpoint = this.remoteEndpoint;
        if (remoteEndpoint == null) {
            this.logger.warn("Could not determine remote endpoint, failed to send '{}'.", (Object)message);
            return;
        }
        remoteEndpoint.sendString(message);
    }
}

