"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getClientBasedOnDataSource = getClientBasedOnDataSource;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function getClientBasedOnDataSource(context, dataSourceEnabled, request, dataSourceId, client) {
  if (dataSourceEnabled && dataSourceId && dataSourceId.trim().length != 0) {
    // client for remote cluster
    return context.dataSource.opensearch.legacy.getClient(dataSourceId).callAPI;
  } else {
    // fall back to default local cluster
    return client.asScoped(request).callAsCurrentUser;
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJnZXRDbGllbnRCYXNlZE9uRGF0YVNvdXJjZSIsImNvbnRleHQiLCJkYXRhU291cmNlRW5hYmxlZCIsInJlcXVlc3QiLCJkYXRhU291cmNlSWQiLCJjbGllbnQiLCJ0cmltIiwibGVuZ3RoIiwiZGF0YVNvdXJjZSIsIm9wZW5zZWFyY2giLCJsZWdhY3kiLCJnZXRDbGllbnQiLCJjYWxsQVBJIiwiYXNTY29wZWQiLCJjYWxsQXNDdXJyZW50VXNlciJdLCJzb3VyY2VzIjpbImhlbHBlcnMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQge1xuICBJTGVnYWN5Q2x1c3RlckNsaWVudCxcbiAgT3BlblNlYXJjaERhc2hib2FyZHNSZXF1ZXN0LFxuICBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXG59IGZyb20gJy4uLy4uLy4uLy4uL3NyYy9jb3JlL3NlcnZlcic7XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRDbGllbnRCYXNlZE9uRGF0YVNvdXJjZShcbiAgY29udGV4dDogUmVxdWVzdEhhbmRsZXJDb250ZXh0LFxuICBkYXRhU291cmNlRW5hYmxlZDogYm9vbGVhbixcbiAgcmVxdWVzdDogT3BlblNlYXJjaERhc2hib2FyZHNSZXF1ZXN0LFxuICBkYXRhU291cmNlSWQ6IHN0cmluZyxcbiAgY2xpZW50OiBJTGVnYWN5Q2x1c3RlckNsaWVudFxuKTogKGVuZHBvaW50OiBzdHJpbmcsIGNsaWVudFBhcmFtcz86IFJlY29yZDxzdHJpbmcsIGFueT4pID0+IGFueSB7XG4gIGlmIChkYXRhU291cmNlRW5hYmxlZCAmJiBkYXRhU291cmNlSWQgJiYgZGF0YVNvdXJjZUlkLnRyaW0oKS5sZW5ndGggIT0gMCkge1xuICAgIC8vIGNsaWVudCBmb3IgcmVtb3RlIGNsdXN0ZXJcbiAgICByZXR1cm4gY29udGV4dC5kYXRhU291cmNlLm9wZW5zZWFyY2gubGVnYWN5LmdldENsaWVudChkYXRhU291cmNlSWQpLmNhbGxBUEk7XG4gIH0gZWxzZSB7XG4gICAgLy8gZmFsbCBiYWNrIHRvIGRlZmF1bHQgbG9jYWwgY2x1c3RlclxuICAgIHJldHVybiBjbGllbnQuYXNTY29wZWQocmVxdWVzdCkuY2FsbEFzQ3VycmVudFVzZXI7XG4gIH1cbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7O0FBUU8sU0FBU0EsMEJBQTBCQSxDQUN4Q0MsT0FBOEIsRUFDOUJDLGlCQUEwQixFQUMxQkMsT0FBb0MsRUFDcENDLFlBQW9CLEVBQ3BCQyxNQUE0QixFQUNtQztFQUMvRCxJQUFJSCxpQkFBaUIsSUFBSUUsWUFBWSxJQUFJQSxZQUFZLENBQUNFLElBQUksQ0FBQyxDQUFDLENBQUNDLE1BQU0sSUFBSSxDQUFDLEVBQUU7SUFDeEU7SUFDQSxPQUFPTixPQUFPLENBQUNPLFVBQVUsQ0FBQ0MsVUFBVSxDQUFDQyxNQUFNLENBQUNDLFNBQVMsQ0FBQ1AsWUFBWSxDQUFDLENBQUNRLE9BQU87RUFDN0UsQ0FBQyxNQUFNO0lBQ0w7SUFDQSxPQUFPUCxNQUFNLENBQUNRLFFBQVEsQ0FBQ1YsT0FBTyxDQUFDLENBQUNXLGlCQUFpQjtFQUNuRDtBQUNGIn0=