"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryInsightsPlugin = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const QueryInsightsPlugin = function (Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.queryInsights = components.clientAction.namespaceFactory();
  const queryInsights = Client.prototype.queryInsights.prototype;
  queryInsights.getTopNQueries = ca({
    url: {
      fmt: `/_insights/top_queries`
    },
    method: 'GET'
  });
  queryInsights.getTopNQueriesLatency = ca({
    url: {
      fmt: `/_insights/top_queries?type=latency&from=<%=from%>&to=<%=to%>`,
      req: {
        from: {
          type: 'string',
          required: true
        },
        to: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  queryInsights.getTopNQueriesCpu = ca({
    url: {
      fmt: `/_insights/top_queries?type=cpu&from=<%=from%>&to=<%=to%>`,
      req: {
        from: {
          type: 'string',
          required: true
        },
        to: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  queryInsights.getTopNQueriesMemory = ca({
    url: {
      fmt: `/_insights/top_queries?type=memory&from=<%=from%>&to=<%=to%>`,
      req: {
        from: {
          type: 'string',
          required: true
        },
        to: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  queryInsights.getTopNQueriesLatencyForId = ca({
    url: {
      fmt: `/_insights/top_queries?type=latency&from=<%=from%>&to=<%=to%><% if (id) { %>&id=<%=id%><% } %>`,
      req: {
        from: {
          type: 'string',
          required: true
        },
        to: {
          type: 'string',
          required: true
        },
        id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  queryInsights.getTopNQueriesCpuForId = ca({
    url: {
      fmt: `/_insights/top_queries?type=latency&from=<%=from%>&to=<%=to%><% if (id) { %>&id=<%=id%><% } %>`,
      req: {
        from: {
          type: 'string',
          required: true
        },
        to: {
          type: 'string',
          required: true
        },
        id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  queryInsights.getTopNQueriesMemoryForId = ca({
    url: {
      fmt: `/_insights/top_queries?type=latency&from=<%=from%>&to=<%=to%><% if (id) { %>&id=<%=id%><% } %>`,
      req: {
        from: {
          type: 'string',
          required: true
        },
        to: {
          type: 'string',
          required: true
        },
        id: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  queryInsights.getSettings = ca({
    url: {
      fmt: `_cluster/settings?include_defaults=true`
    },
    method: 'GET'
  });
  queryInsights.setSettings = ca({
    url: {
      fmt: `_cluster/settings`
    },
    method: 'PUT',
    needBody: true
  });
};
exports.QueryInsightsPlugin = QueryInsightsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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