/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools.android;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.debug.RunnerException;
import processing.app.exec.ProcessHelper;
import processing.app.exec.ProcessResult;
import processing.app.preproc.PdePreprocessor;
import processing.app.preproc.PreprocessResult;
import processing.app.tools.android.AndroidSDK;
import processing.app.tools.android.AndroidTool;
import processing.core.PApplet;

class Build {
    static SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMdd.HHmm");
    static String basePackage = "processing.android.test";
    private final Editor editor;
    private final AndroidSDK sdk;
    String className;
    File tempBuildFolder;
    File buildFile;
    static final String sdkVersion = "7";
    String sketchSize;
    String sketchWidth = "screenWidth";
    String sketchHeight = "screenHeight";
    String sketchRenderer = "A2D";

    public Build(Editor editor, AndroidSDK androidSDK) {
        this.editor = editor;
        this.sdk = androidSDK;
    }

    protected boolean calcSketchSize() {
        Sketch sketch = this.editor.getSketch();
        String string = Sketch.scrubComments((String)sketch.getCode(0).getProgram());
        String[] stringArray = PApplet.match((String)string, (String)"(?:^|\\s|;)size\\s*\\(\\s*(\\S+)\\s*,\\s*(\\d+),?\\s*([^\\)]*)\\s*\\)\\s*\\;");
        if (stringArray != null) {
            try {
                Integer.parseInt(stringArray[1]);
                Integer.parseInt(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                Base.showWarning("Could not find sketch size", "The size of this applet could not automatically be\ndetermined from your code.\nUse only numeric values (not variables) for the size()\ncommand. See the size() reference for an explanation.", null);
                return false;
            }
            this.sketchSize = stringArray[0];
            this.sketchWidth = stringArray[1];
            this.sketchHeight = stringArray[2];
            if (stringArray[3].trim().length() != 0) {
                this.sketchRenderer = stringArray[3];
            }
        }
        return true;
    }

    public File createProject() {
        block9: {
            Sketch sketch = this.editor.getSketch();
            try {
                this.tempBuildFolder = this.createTempBuildFolder(sketch);
            }
            catch (IOException iOException) {
                this.editor.statusError(iOException);
                return null;
            }
            File file = new File(this.tempBuildFolder, "src");
            try {
                File file2 = this.mkdirs(file, this.getPackageName().replace('.', '/'));
                String string = file2.getAbsolutePath();
                sketch.prepare();
                if (!this.calcSketchSize()) {
                    this.editor.statusError("Could not parse the size() command.");
                    return null;
                }
                this.className = sketch.preprocess(string, new Preproc(sketch.getName()));
                if (this.className == null) break block9;
                File file3 = new File(this.tempBuildFolder, "AndroidManifest.xml");
                this.writeAndroidManifest(file3, sketch.getName(), this.className);
                this.writeBuildProps(new File(this.tempBuildFolder, "build.properties"));
                this.buildFile = new File(this.tempBuildFolder, "build.xml");
                this.writeBuildXML(this.buildFile, sketch.getName());
                this.writeDefaultProps(new File(this.tempBuildFolder, "default.properties"));
                this.writeLocalProps(new File(this.tempBuildFolder, "local.properties"));
                this.writeRes(new File(this.tempBuildFolder, "res"), this.className);
                File file4 = this.mkdirs(this.tempBuildFolder, "libs");
                File file5 = this.mkdirs(this.tempBuildFolder, "assets");
                InputStream inputStream = PApplet.createInput((File)AndroidTool.getCoreZipLocation());
                PApplet.saveStream((File)new File(file4, "processing-core.jar"), (InputStream)inputStream);
                try {
                    this.writeLibraries(file4, file5);
                    File file6 = sketch.getDataFolder();
                    if (file6.exists()) {
                        Base.copyDir(file6, file5);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new RunnerException(iOException.getMessage());
                }
            }
            catch (RunnerException runnerException) {
                this.editor.statusError(runnerException);
                return null;
            }
            catch (IOException iOException) {
                this.editor.statusError(iOException);
                return null;
            }
        }
        return this.tempBuildFolder;
    }

    private File createTempBuildFolder(Sketch sketch) throws IOException {
        File file = File.createTempFile("android", ".pde");
        if (!file.delete() || !file.mkdir()) {
            throw new IOException("Cannot create temp dir " + file + " to build android sketch");
        }
        return file;
    }

    protected File createExportFolder() throws IOException {
        Sketch sketch = this.editor.getSketch();
        File file = new File(sketch.getFolder(), "android");
        if (file.exists()) {
            Date date = new Date(file.lastModified());
            File file2 = new File(sketch.getFolder(), "android." + dateFormat.format(date));
            boolean bl = file.renameTo(file2);
            if (!bl) {
                ProcessResult processResult;
                try {
                    System.err.println("createProject renameTo() failed, resorting to mv/move instead.");
                    ProcessHelper processHelper = new ProcessHelper("mv", file.getAbsolutePath(), file2.getAbsolutePath());
                    processResult = processHelper.execute();
                }
                catch (IOException iOException) {
                    this.editor.statusError(iOException);
                    return null;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    return null;
                }
                if (!processResult.succeeded()) {
                    System.err.println(processResult.getStderr());
                    Base.showWarning("Failed to rename", "Could not rename the old \u201candroid\u201d build folder.\nPlease delete, close, or rename the folder\n" + file.getAbsolutePath() + "\n" + "and try again.", null);
                    Base.openFolder(sketch.getFolder());
                    return null;
                }
            }
        } else {
            boolean bl = file.mkdirs();
            if (!bl) {
                Base.showWarning("Folders, folders, folders", "Could not create the necessary folders to build.\nPerhaps you have some file permissions to sort out?", null);
                return null;
            }
        }
        return file;
    }

    protected boolean antBuild(String string) {
        Project project = new Project();
        String string2 = this.buildFile.getAbsolutePath().replace('\\', '/');
        project.setUserProperty("ant.file", string2);
        project.setUserProperty("build.compiler", "extJavac");
        DefaultLogger defaultLogger = new DefaultLogger();
        defaultLogger.setErrorPrintStream(System.err);
        defaultLogger.setMessageOutputLevel(0);
        project.addBuildListener((BuildListener)defaultLogger);
        DefaultLogger defaultLogger2 = new DefaultLogger();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        defaultLogger2.setErrorPrintStream(printStream);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream2);
        defaultLogger2.setOutputPrintStream(printStream2);
        defaultLogger2.setMessageOutputLevel(2);
        project.addBuildListener((BuildListener)defaultLogger2);
        try {
            this.editor.statusNotice("Building sketch for Android...");
            project.fireBuildStarted();
            project.init();
            ProjectHelper projectHelper = ProjectHelper.getProjectHelper();
            project.addReference("ant.projectHelper", (Object)projectHelper);
            projectHelper.parse(project, (Object)this.buildFile);
            project.executeTarget(string);
            this.editor.statusNotice("Finished building sketch.");
            return true;
        }
        catch (BuildException buildException) {
            String[] stringArray;
            project.fireBuildFinished((Throwable)buildException);
            String string3 = new String(byteArrayOutputStream2.toByteArray());
            for (String string4 : stringArray = string3.split(System.getProperty("line.separator"))) {
                int n;
                int n2 = string4.indexOf("[javac]");
                if (n2 == -1) continue;
                Sketch sketch = this.editor.getSketch();
                int n3 = n2 + "[javac]".length() + 1;
                String[] stringArray2 = PApplet.match((String)string4.substring(n3), (String)"^(.+):([0-9]+):\\s+(.+)$");
                if (stringArray2 == null) continue;
                String string5 = stringArray2[1];
                RunnerException runnerException = sketch.placeException(stringArray2[3], string5 = string5.substring(string5.lastIndexOf(47) + 1), n = PApplet.parseInt((String)stringArray2[2]) - 1);
                if (runnerException == null) continue;
                runnerException.hideStackTrace();
                this.editor.statusError(runnerException);
                return false;
            }
            this.editor.statusError((Exception)((Object)buildException));
            return false;
        }
    }

    protected String getPackageName() {
        return basePackage + "." + this.editor.getSketch().getName().toLowerCase();
    }

    protected String getClassName() {
        return this.className;
    }

    String getPathForAPK(String string) {
        Sketch sketch = this.editor.getSketch();
        String string2 = string.equals("release") ? "unsigned" : "debug";
        String string3 = "bin/" + sketch.getName() + "-" + string2 + ".apk";
        File file = new File(this.tempBuildFolder, string3);
        return file.getAbsolutePath();
    }

    private void writeAndroidManifest(File file, String string, String string2) {
        PrintWriter printWriter = PApplet.createWriter((File)file);
        printWriter.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        printWriter.println("<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\" ");
        printWriter.println("          package=\"" + this.getPackageName() + "\" ");
        printWriter.println("          android:versionCode=\"1\" ");
        printWriter.println("          android:versionName=\"1.0\">");
        printWriter.println("  <uses-sdk android:minSdkVersion=" + Build.q(sdkVersion) + " />");
        printWriter.println("  <uses-permission android:name=\"android.permission.INTERNET\" />");
        printWriter.println("  <uses-permission android:name=\"android.permission.WRITE_EXTERNAL_STORAGE\" />");
        printWriter.println("  <application android:label=" + Build.q("@string/app_name"));
        printWriter.println("               android:debuggable=" + Build.q("true") + ">");
        printWriter.println("    <activity android:name=" + Build.q("." + string2));
        printWriter.println("              android:label=\"@string/app_name\">");
        printWriter.println("      <intent-filter>");
        printWriter.println("        <action android:name=\"android.intent.action.MAIN\" />");
        printWriter.println("        <category android:name=\"android.intent.category.LAUNCHER\" />");
        printWriter.println("      </intent-filter>");
        printWriter.println("    </activity>");
        printWriter.println("  </application>");
        printWriter.println("</manifest>");
        printWriter.flush();
        printWriter.close();
    }

    private void writeBuildProps(File file) {
        PrintWriter printWriter = PApplet.createWriter((File)file);
        printWriter.println("application-package=" + this.getPackageName());
        printWriter.flush();
        printWriter.close();
    }

    private void writeBuildXML(File file, String string) {
        PrintWriter printWriter = PApplet.createWriter((File)file);
        printWriter.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        printWriter.println("<project name=\"" + string + "\" default=\"help\">");
        printWriter.println("  <property file=\"local.properties\"/>");
        printWriter.println("  <property file=\"build.properties\"/>");
        printWriter.println("  <property file=\"default.properties\"/>");
        printWriter.println("  <path id=\"android.antlibs\">");
        printWriter.println("    <pathelement path=\"${sdk.dir}/tools/lib/anttasks.jar\" />");
        printWriter.println("    <pathelement path=\"${sdk.dir}/tools/lib/sdklib.jar\" />");
        printWriter.println("    <pathelement path=\"${sdk.dir}/tools/lib/androidprefs.jar\" />");
        printWriter.println("    <pathelement path=\"${sdk.dir}/tools/lib/apkbuilder.jar\" />");
        printWriter.println("    <pathelement path=\"${sdk.dir}/tools/lib/jarutils.jar\" />");
        printWriter.println("  </path>");
        printWriter.println("  <taskdef name=\"setup\"");
        printWriter.println("           classname=\"com.android.ant.SetupTask\"");
        printWriter.println("           classpathref=\"android.antlibs\" />");
        printWriter.println("  <setup />");
        printWriter.println("</project>");
        printWriter.flush();
        printWriter.close();
    }

    private void writeDefaultProps(File file) {
        PrintWriter printWriter = PApplet.createWriter((File)file);
        printWriter.println("target=Google Inc.:Google APIs:7");
        printWriter.flush();
        printWriter.close();
    }

    private void writeLocalProps(File file) {
        PrintWriter printWriter = PApplet.createWriter((File)file);
        String string = this.sdk.getSdkFolder().getAbsolutePath();
        if (Base.isWindows()) {
            printWriter.println("sdk.dir=" + string.replace('\\', '/'));
        } else {
            printWriter.println("sdk.dir=" + string);
        }
        printWriter.flush();
        printWriter.close();
    }

    private void writeRes(File file, String string) throws RunnerException {
        File file2 = this.mkdirs(file, "layout");
        File file3 = new File(file2, "main.xml");
        this.writeResLayoutMain(file3);
        File file4 = this.mkdirs(file, "values");
        File file5 = new File(file4, "strings.xml");
        Build.writeResValuesStrings(file5, string);
    }

    private File mkdirs(File file, String string) throws RunnerException {
        File file2 = new File(file, string);
        if (!file2.exists() && !file2.mkdirs()) {
            throw new RunnerException("Could not create " + file2);
        }
        return file2;
    }

    private void writeResLayoutMain(File file) {
        PrintWriter printWriter = PApplet.createWriter((File)file);
        printWriter.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        printWriter.println("<LinearLayout xmlns:android=\"http://schemas.android.com/apk/res/android\"");
        printWriter.println("              android:orientation=\"vertical\"");
        printWriter.println("              android:layout_width=\"fill_parent\"");
        printWriter.println("              android:layout_height=\"fill_parent\">");
        printWriter.println("</LinearLayout>");
        printWriter.flush();
        printWriter.close();
    }

    private static void writeResValuesStrings(File file, String string) {
        PrintWriter printWriter = PApplet.createWriter((File)file);
        printWriter.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        printWriter.println("<resources>");
        printWriter.println("  <string name=\"app_name\">" + string + "</string>");
        printWriter.println("</resources>");
        printWriter.flush();
        printWriter.close();
    }

    private void writeLibraries(File file, File file2) throws IOException {
        Object object;
        Object object2;
        Sketch sketch = this.editor.getSketch();
        for (File[] fileArray : sketch.getImportedLibraries()) {
            File file3 = new File((File)fileArray, "export.txt");
            HashMap<String, String> hashMap = Base.readSettings(file3);
            String object3 = hashMap.get("android");
            object2 = null;
            object2 = object3 != null ? PApplet.splitTokens((String)object3, (String)", ") : fileArray.list();
            for (int string = 0; string < ((String[])object2).length; ++string) {
                object2[string] = PApplet.trim((String)object2[string]);
                if (((String)object2[string]).equals("") || ((String)object2[string]).equals(".") || ((String)object2[string]).equals("..")) continue;
                object = new File((File)fileArray, (String)object2[string]);
                if (!((File)object).exists()) {
                    System.err.println("File " + (String)object2[string] + " does not exist");
                    continue;
                }
                if (((File)object).isDirectory()) {
                    System.err.println("Ignoring sub-folder \"" + (String)object2[string] + "\"");
                    continue;
                }
                String string2 = ((File)object).getName();
                String string3 = string2.toLowerCase();
                if (string3.endsWith(".zip") || string3.endsWith(".jar")) {
                    String string4 = string2.substring(0, string2.length() - 4) + ".jar";
                    Base.copyFile((File)object, new File(file, string4));
                    continue;
                }
                Base.copyFile((File)object, new File(file2, string2));
            }
        }
        File file4 = sketch.getCodeFolder();
        if (file4 != null && file4.exists()) {
            for (File file3 : file4.listFiles()) {
                String string;
                if (file3.isDirectory() || !(string = ((String)(object2 = file3.getName())).toLowerCase()).endsWith(".jar") && !string.endsWith(".zip")) continue;
                object = ((String)object2).substring(0, ((String)object2).length() - 4) + ".jar";
                Base.copyFile(file3, new File(file, (String)object));
            }
        }
    }

    private static final String q(String string) {
        return "\"" + string + "\"";
    }

    public void cleanup() {
        this.tempBuildFolder.deleteOnExit();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Preproc
    extends PdePreprocessor {
        public Preproc(String string) throws IOException {
            super(string);
        }

        @Override
        public PreprocessResult write(Writer writer, String string, String[] stringArray) throws RunnerException, RecognitionException, TokenStreamException {
            if (Build.this.sketchSize != null) {
                int n = string.indexOf(Build.this.sketchSize);
                string = string.substring(0, n) + string.substring(n + Build.this.sketchSize.length());
            }
            return super.write(writer, string, stringArray);
        }

        @Override
        protected int writeImports(PrintWriter printWriter, List<String> list, List<String> list2) {
            printWriter.println("package " + Build.this.getPackageName() + ";");
            printWriter.println();
            return 2 + super.writeImports(printWriter, list, list2);
        }

        @Override
        protected void writeFooter(PrintWriter printWriter, String string) {
            if (this.mode == PdePreprocessor.Mode.STATIC) {
                printWriter.println("noLoop();");
                printWriter.println(this.indent + "}");
            }
            if (this.mode == PdePreprocessor.Mode.STATIC || this.mode == PdePreprocessor.Mode.ACTIVE) {
                printWriter.println();
                printWriter.println(this.indent + "public int sketchWidth() { return " + Build.this.sketchWidth + "; }");
                printWriter.println(this.indent + "public int sketchHeight() { return " + Build.this.sketchHeight + "; }");
                printWriter.println(this.indent + "public String sketchRenderer() { return " + Build.this.sketchRenderer + "; }");
                printWriter.println("}");
            }
        }

        @Override
        public String[] getCoreImports() {
            return new String[]{"processing.core.*", "processing.xml.*"};
        }

        @Override
        public String[] getDefaultImports() {
            String string = Preferences.get("android.preproc.imports.list");
            if (string != null) {
                return PApplet.splitTokens((String)string, (String)", ");
            }
            String[] stringArray = new String[]{"android.view.MotionEvent", "android.view.KeyEvent", "android.graphics.Bitmap", "java.io.*", "java.util.*"};
            Preferences.set("android.preproc.imports.list", PApplet.join((String[])stringArray, (String)","));
            return stringArray;
        }
    }
}

