# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx.logical_routers.routing.static_routes.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class BfdPeers(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.logical_routers.routing.static_routes.bfd_peers'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _BfdPeersStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               logical_router_id,
               static_hop_bfd_peer,
               ):
        """
        Creates a BFD peer for static route. The required parameters includes
        peer IP address. 
        
        Please use below Policy APIs. 
        POST /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers

        .. deprecated:: unknown

        :type  logical_router_id: :class:`str`
        :param logical_router_id: (required)
        :type  static_hop_bfd_peer: :class:`com.vmware.nsx.model_client.StaticHopBfdPeer`
        :param static_hop_bfd_peer: (required)
        :rtype: :class:`com.vmware.nsx.model_client.StaticHopBfdPeer`
        :return: com.vmware.nsx.model.StaticHopBfdPeer
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.logical_routers.routing.static_routes.BfdPeers.create is deprecated.', DeprecationWarning)
        return self._invoke('create',
                            {
                            'logical_router_id': logical_router_id,
                            'static_hop_bfd_peer': static_hop_bfd_peer,
                            })

    def delete(self,
               logical_router_id,
               bfd_peer_id,
               force=None,
               ):
        """
        Deletes the specified BFD peer present on specified logical router. 
        
        Please use below Policy APIs. 
        DELETE
        /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers/<bfd-peer-id>

        .. deprecated:: unknown

        :type  logical_router_id: :class:`str`
        :param logical_router_id: (required)
        :type  bfd_peer_id: :class:`str`
        :param bfd_peer_id: (required)
        :type  force: :class:`bool` or ``None``
        :param force: Force delete the resource even if it is being used somewhere
            (optional, default to false)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.logical_routers.routing.static_routes.BfdPeers.delete is deprecated.', DeprecationWarning)
        return self._invoke('delete',
                            {
                            'logical_router_id': logical_router_id,
                            'bfd_peer_id': bfd_peer_id,
                            'force': force,
                            })

    def get(self,
            logical_router_id,
            bfd_peer_id,
            ):
        """
        Read the BFD peer having specified ID. 
        
        Please use below Policy APIs. 
        GET
        /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers/<bfd-peer-id>

        .. deprecated:: unknown

        :type  logical_router_id: :class:`str`
        :param logical_router_id: (required)
        :type  bfd_peer_id: :class:`str`
        :param bfd_peer_id: (required)
        :rtype: :class:`com.vmware.nsx.model_client.StaticHopBfdPeer`
        :return: com.vmware.nsx.model.StaticHopBfdPeer
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.logical_routers.routing.static_routes.BfdPeers.get is deprecated.', DeprecationWarning)
        return self._invoke('get',
                            {
                            'logical_router_id': logical_router_id,
                            'bfd_peer_id': bfd_peer_id,
                            })

    def list(self,
             logical_router_id,
             cursor=None,
             included_fields=None,
             page_size=None,
             sort_ascending=None,
             sort_by=None,
             ):
        """
        Returns information about all BFD peers created on specified logical
        router for static routes. 
        
        Please use below Policy APIs. 
        GET /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers

        .. deprecated:: unknown

        :type  logical_router_id: :class:`str`
        :param logical_router_id: (required)
        :type  cursor: :class:`str` or ``None``
        :param cursor: Opaque cursor to be used for getting next page of records (supplied
            by current result page) (optional)
        :type  included_fields: :class:`str` or ``None``
        :param included_fields: Comma separated list of fields that should be included in query
            result (optional)
        :type  page_size: :class:`long` or ``None``
        :param page_size: Maximum number of results to return in this page (server may return
            fewer) (optional, default to 1000)
        :type  sort_ascending: :class:`bool` or ``None``
        :param sort_ascending: (optional)
        :type  sort_by: :class:`str` or ``None``
        :param sort_by: Field by which records are sorted (optional)
        :rtype: :class:`com.vmware.nsx.model_client.StaticHopBfdPeerListResult`
        :return: com.vmware.nsx.model.StaticHopBfdPeerListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.logical_routers.routing.static_routes.BfdPeers.list is deprecated.', DeprecationWarning)
        return self._invoke('list',
                            {
                            'logical_router_id': logical_router_id,
                            'cursor': cursor,
                            'included_fields': included_fields,
                            'page_size': page_size,
                            'sort_ascending': sort_ascending,
                            'sort_by': sort_by,
                            })

    def update(self,
               logical_router_id,
               bfd_peer_id,
               static_hop_bfd_peer,
               ):
        """
        Modifies the static route BFD peer. Modifiable parameters includes peer
        IP, enable flag and configuration of the BFD peer. 
        
        Please use below Policy APIs. 
        PUT
        /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers/<bfd-peer-id>

        .. deprecated:: unknown

        :type  logical_router_id: :class:`str`
        :param logical_router_id: (required)
        :type  bfd_peer_id: :class:`str`
        :param bfd_peer_id: (required)
        :type  static_hop_bfd_peer: :class:`com.vmware.nsx.model_client.StaticHopBfdPeer`
        :param static_hop_bfd_peer: (required)
        :rtype: :class:`com.vmware.nsx.model_client.StaticHopBfdPeer`
        :return: com.vmware.nsx.model.StaticHopBfdPeer
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        warn('com.vmware.nsx.logical_routers.routing.static_routes.BfdPeers.update is deprecated.', DeprecationWarning)
        return self._invoke('update',
                            {
                            'logical_router_id': logical_router_id,
                            'bfd_peer_id': bfd_peer_id,
                            'static_hop_bfd_peer': static_hop_bfd_peer,
                            })
class _BfdPeersStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'logical_router_id': type.StringType(),
            'static_hop_bfd_peer': type.ReferenceType('com.vmware.nsx.model_client', 'StaticHopBfdPeer'),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/logical-routers/{logical-router-id}/routing/static-routes/bfd-peers',
            request_body_parameter='static_hop_bfd_peer',
            path_variables={
                'logical_router_id': 'logical-router-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'logical_router_id': type.StringType(),
            'bfd_peer_id': type.StringType(),
            'force': type.OptionalType(type.BooleanType()),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/api/v1/logical-routers/{logical-router-id}/routing/static-routes/bfd-peers/{bfd-peer-id}',
            path_variables={
                'logical_router_id': 'logical-router-id',
                'bfd_peer_id': 'bfd-peer-id',
            },
             header_parameters={
                   },
            query_parameters={
                'force': 'force',
            },
            content_type='application/json'
        )

        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'logical_router_id': type.StringType(),
            'bfd_peer_id': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/logical-routers/{logical-router-id}/routing/static-routes/bfd-peers/{bfd-peer-id}',
            path_variables={
                'logical_router_id': 'logical-router-id',
                'bfd_peer_id': 'bfd-peer-id',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'logical_router_id': type.StringType(),
            'cursor': type.OptionalType(type.StringType()),
            'included_fields': type.OptionalType(type.StringType()),
            'page_size': type.OptionalType(type.IntegerType()),
            'sort_ascending': type.OptionalType(type.BooleanType()),
            'sort_by': type.OptionalType(type.StringType()),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/api/v1/logical-routers/{logical-router-id}/routing/static-routes/bfd-peers',
            path_variables={
                'logical_router_id': 'logical-router-id',
            },
             header_parameters={
                         },
            query_parameters={
                'cursor': 'cursor',
                'included_fields': 'included_fields',
                'page_size': 'page_size',
                'sort_ascending': 'sort_ascending',
                'sort_by': 'sort_by',
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'logical_router_id': type.StringType(),
            'bfd_peer_id': type.StringType(),
            'static_hop_bfd_peer': type.ReferenceType('com.vmware.nsx.model_client', 'StaticHopBfdPeer'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
        ]
        update_output_validator_list = [
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/api/v1/logical-routers/{logical-router-id}/routing/static-routes/bfd-peers/{bfd-peer-id}',
            request_body_parameter='static_hop_bfd_peer',
            path_variables={
                'logical_router_id': 'logical-router-id',
                'bfd_peer_id': 'bfd-peer-id',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'StaticHopBfdPeer'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.VoidType(),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'StaticHopBfdPeer'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'StaticHopBfdPeerListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'StaticHopBfdPeer'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
            'delete': delete_rest_metadata,
            'get': get_rest_metadata,
            'list': list_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.logical_routers.routing.static_routes.bfd_peers',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'BfdPeers': BfdPeers,
    }

