/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.RSAClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.ClientKeyExchangeParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RSAClientKeyExchangeParser<T extends RSAClientKeyExchangeMessage>
extends ClientKeyExchangeParser<T> {
    private static final Logger LOGGER = LogManager.getLogger();

    public RSAClientKeyExchangeParser(int startposition, byte[] array, ProtocolVersion version, Config config) {
        super(startposition, array, version, config);
    }

    @Override
    protected void parseHandshakeMessageContent(T msg) {
        LOGGER.debug("Parsing RSAClientKeyExchangeMessage");
        this.parseSerializedPublicKeyLength(msg);
        this.parseSerializedPublicKey(msg);
    }

    protected void parseRsaParams(T msg) {
        this.parseSerializedPublicKeyLength(msg);
        this.parseSerializedPublicKey(msg);
    }

    @Override
    protected T createHandshakeMessage() {
        return (T)new RSAClientKeyExchangeMessage();
    }

    private void parseSerializedPublicKeyLength(T msg) {
        if (this.getVersion().isSSL()) {
            ((ClientKeyExchangeMessage)msg).setPublicKeyLength(this.getBytesLeft());
        } else {
            ((ClientKeyExchangeMessage)msg).setPublicKeyLength(this.parseIntField(2));
        }
        LOGGER.debug("SerializedPublicKeyLength: " + ((ClientKeyExchangeMessage)msg).getPublicKeyLength().getValue());
    }

    private void parseSerializedPublicKey(T msg) {
        ((ClientKeyExchangeMessage)msg).setPublicKey(this.parseByteArrayField((Integer)((ClientKeyExchangeMessage)msg).getPublicKeyLength().getValue()));
        LOGGER.debug("SerializedPublicKey: " + ArrayConverter.bytesToHexString((byte[])((byte[])((ClientKeyExchangeMessage)msg).getPublicKey().getValue())));
    }
}

