/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ECPointFormatExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ECPointFormatExtensionParser
extends ExtensionParser<ECPointFormatExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ECPointFormatExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public void parseExtensionMessageContent(ECPointFormatExtensionMessage msg) {
        LOGGER.debug("Parsing ECPointFormatExtensionMessage");
        this.parsePointFormatsLength(msg);
        this.parsePointFormat(msg);
    }

    @Override
    protected ECPointFormatExtensionMessage createExtensionMessage() {
        return new ECPointFormatExtensionMessage();
    }

    private void parsePointFormatsLength(ECPointFormatExtensionMessage msg) {
        msg.setPointFormatsLength(this.parseIntField(1));
        LOGGER.debug("PointFormatsLength: " + msg.getPointFormatsLength().getValue());
    }

    private void parsePointFormat(ECPointFormatExtensionMessage msg) {
        msg.setPointFormats(this.parseByteArrayField((Integer)msg.getPointFormatsLength().getValue()));
        LOGGER.debug("PointFormats: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getPointFormats().getValue())));
    }
}

