/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtendedRandomExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtendedRandomExtensionSerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtendedRandomExtensionPreparator
extends ExtensionPreparator<ExtendedRandomExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ExtendedRandomExtensionMessage message;

    public ExtendedRandomExtensionPreparator(Chooser chooser, ExtendedRandomExtensionMessage message, ExtendedRandomExtensionSerializer serializer) {
        super(chooser, message, serializer);
        this.message = message;
    }

    @Override
    public void prepareExtensionContent() {
        if (this.chooser.getConnectionEndType().equals((Object)ConnectionEndType.CLIENT)) {
            LOGGER.debug("Preparing Client Extended Random of Extended Random Extension Message.");
            this.message.setExtendedRandom(this.chooser.getClientExtendedRandom());
            LOGGER.debug("Prepared the Client Extended Random with value " + ArrayConverter.bytesToHexString((byte[])((byte[])this.message.getExtendedRandom().getValue())));
        }
        if (this.chooser.getConnectionEndType().equals((Object)ConnectionEndType.SERVER)) {
            LOGGER.debug("Preparing Server Extended Random of Extended Random Extension Message.");
            if (this.chooser.getServerExtendedRandom().length != this.chooser.getClientExtendedRandom().length) {
                LOGGER.debug("Extended Random of Client is not same length as Default Server Extended Random. Generating fresh Server Extended Random of appropriate length.");
                byte[] generatedExtendedRandom = this.prepareExtendedRandom(this.chooser.getClientExtendedRandom().length);
                this.message.setExtendedRandom(generatedExtendedRandom);
            } else {
                this.message.setExtendedRandom(this.chooser.getServerExtendedRandom());
            }
            LOGGER.debug("Prepared the Server Extended Random with value " + ArrayConverter.bytesToHexString((byte[])((byte[])this.message.getExtendedRandom().getValue())));
        }
        this.prepareExtendedRandomLength(this.message);
    }

    private void prepareExtendedRandomLength(ExtendedRandomExtensionMessage msg) {
        msg.setExtendedRandomLength(((byte[])msg.getExtendedRandom().getValue()).length);
        LOGGER.debug("ExtendedRandomLength: " + msg.getExtendedRandomLength().getValue());
    }

    private byte[] prepareExtendedRandom(int length) {
        byte[] randomBytes = new byte[length];
        new Random().nextBytes(randomBytes);
        return randomBytes;
    }
}

