/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.MessageActionResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PopAndSendAction
extends MessageAction
implements SendingAction {
    private static final Logger LOGGER = LogManager.getLogger();
    Integer index = null;

    public PopAndSendAction() {
    }

    public PopAndSendAction(String connectionAlias) {
        super(connectionAlias);
    }

    public PopAndSendAction(String connectionAlias, int index) {
        super(connectionAlias);
        this.index = index;
    }

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        TlsContext tlsContext = state.getTlsContext(this.connectionAlias);
        if (this.isExecuted()) {
            throw new WorkflowExecutionException("Action already executed!");
        }
        LinkedList<ProtocolMessage> messageBuffer = tlsContext.getMessageBuffer();
        if (this.index != null && this.index >= 0) {
            if (this.index >= messageBuffer.size()) {
                throw new WorkflowExecutionException("Index out of bounds, trying to get element " + this.index + "of message buffer with " + messageBuffer.size() + "elements.");
            }
            this.messages.add(messageBuffer.get(this.index));
            messageBuffer.remove(this.index);
            tlsContext.getRecordBuffer().remove(this.index);
        } else {
            this.messages.add(messageBuffer.pop());
            tlsContext.getRecordBuffer().pop();
        }
        String sending = this.getReadableString(this.messages);
        if (this.connectionAlias == null) {
            LOGGER.info("Sending messages: " + sending);
        } else {
            LOGGER.info("Sending messages (" + this.connectionAlias + "): " + sending);
        }
        try {
            MessageActionResult result = this.sendMessageHelper.sendMessages(this.messages, this.records, tlsContext, false);
            this.messages = new ArrayList<ProtocolMessage>(result.getMessageList());
            this.records = new ArrayList<AbstractRecord>(result.getRecordList());
            this.setExecuted(true);
        }
        catch (IOException E) {
            LOGGER.debug((Object)E);
            this.setExecuted(false);
        }
    }

    public String toString() {
        return "PopAndSendAction(index: " + this.index + ")";
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }

    @Override
    public void setRecords(List<AbstractRecord> records) {
        this.records = records;
    }

    @Override
    public void reset() {
        this.messages = new LinkedList();
        this.records = new LinkedList();
        this.setExecuted(null);
    }

    @Override
    public List<ProtocolMessage> getSendMessages() {
        return this.messages;
    }

    @Override
    public List<AbstractRecord> getSendRecords() {
        return this.records;
    }
}

