/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.SortOrder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.option.DialogAddProxyExcludedDomain;
import org.parosproxy.paros.extension.option.DialogModifyProxyExcludedDomain;
import org.parosproxy.paros.extension.option.ProxyExcludedDomainsTableModel;
import org.parosproxy.paros.extension.option.SecurityProtocolsPanel;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.option.SocksProxyPanel;
import org.zaproxy.zap.model.CommonUserAgents;
import org.zaproxy.zap.network.DomainMatcher;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.ZapNumberSpinner;
import org.zaproxy.zap.utils.ZapPortNumberSpinner;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.AbstractMultipleOptionsTablePanel;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.ProxyDialog;

public class OptionsConnectionPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox chkUseProxyChain = null;
    private JPanel jPanel = null;
    private JPanel panelProxyAuth = null;
    private JPanel panelProxyChain = null;
    private ZapTextField txtProxyChainName = null;
    private ZapPortNumberSpinner spinnerProxyChainPort = null;
    private ZapTextField txtProxyChainRealm = null;
    private ZapTextField txtProxyChainUserName = null;
    private JPasswordField txtProxyChainPassword = null;
    private JCheckBox chkShowPassword = null;
    private JCheckBox chkProxyChainAuth = null;
    private JCheckBox chkProxyChainPrompt = null;
    private ZapNumberSpinner spinnerTimeoutInSecs;
    private JPanel panelGeneral = null;
    private JCheckBox checkBoxSingleCookieRequestHeader;
    private JCheckBox checkBoxHttpStateEnabled;
    private JComboBox<String> commonUserAgents = null;
    private ZapTextField defaultUserAgent = null;
    private JPanel dnsPanel;
    private ZapNumberSpinner dnsTtlSuccessfulQueriesNumberSpinner;
    private SecurityProtocolsPanel securityProtocolsPanel;
    private ProxyExcludedDomainsMultipleOptionsPanel proxyExcludedDomainsPanel;
    private ProxyExcludedDomainsTableModel proxyExcludedDomainsTableModel;
    private final SocksProxyPanel socksProxyPanel = new SocksProxyPanel();

    public OptionsConnectionPanel() {
        this.initialize();
    }

    private JCheckBox getChkShowPassword() {
        if (this.chkShowPassword == null) {
            this.chkShowPassword = new JCheckBox();
            this.chkShowPassword.setText(Constant.messages.getString("conn.options.proxy.auth.showpass"));
            this.chkShowPassword.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (OptionsConnectionPanel.this.chkShowPassword.isSelected()) {
                        OptionsConnectionPanel.this.txtProxyChainPassword.setEchoChar('\u0000');
                    } else {
                        OptionsConnectionPanel.this.txtProxyChainPassword.setEchoChar('*');
                    }
                }
            });
        }
        return this.chkShowPassword;
    }

    private JCheckBox getChkUseProxyChain() {
        if (this.chkUseProxyChain == null) {
            this.chkUseProxyChain = new JCheckBox();
            this.chkUseProxyChain.setText(Constant.messages.getString("conn.options.useProxy"));
            this.chkUseProxyChain.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsConnectionPanel.this.setProxyChainEnabled(OptionsConnectionPanel.this.chkUseProxyChain.isSelected());
                }
            });
        }
        return this.chkUseProxyChain;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints71 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints61 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            JLabel jLabel7 = new JLabel();
            JLabel jLabel6 = new JLabel();
            JLabel jLabel5 = new JLabel();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            jLabel5.setText(Constant.messages.getString("conn.options.proxy.address"));
            jLabel6.setText(Constant.messages.getString("conn.options.proxy.port"));
            jLabel7.setText(Constant.messages.getString("conn.options.proxy.skipAddresses"));
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.gridy = 0;
            gridBagConstraints15.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints15.anchor = 18;
            gridBagConstraints15.fill = 2;
            gridBagConstraints15.gridwidth = 2;
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 0.5;
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.weightx = 0.5;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.ipadx = 50;
            gridBagConstraints41.gridx = 0;
            gridBagConstraints41.gridy = 2;
            gridBagConstraints41.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints41.anchor = 17;
            gridBagConstraints41.fill = 2;
            gridBagConstraints41.weightx = 0.5;
            gridBagConstraints51.gridx = 1;
            gridBagConstraints51.gridy = 2;
            gridBagConstraints51.weightx = 0.5;
            gridBagConstraints51.fill = 2;
            gridBagConstraints51.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints51.anchor = 17;
            gridBagConstraints51.ipadx = 50;
            gridBagConstraints61.gridx = 0;
            gridBagConstraints61.gridy = 3;
            gridBagConstraints61.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints61.fill = 2;
            gridBagConstraints61.weightx = 1.0;
            gridBagConstraints61.gridwidth = 2;
            gridBagConstraints61.anchor = 12;
            gridBagConstraints71.gridx = 0;
            gridBagConstraints71.gridy = 4;
            gridBagConstraints71.weightx = 1.0;
            gridBagConstraints71.weighty = 0.2;
            gridBagConstraints71.fill = 2;
            gridBagConstraints71.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints71.anchor = 12;
            gridBagConstraints71.gridwidth = 2;
            gridBagConstraints71.ipady = 20;
            this.jPanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("conn.options.proxy.useProxyChain"), 0, 0, FontUtils.getFont(FontUtils.Size.standard)));
            this.jPanel.add((Component)this.getChkUseProxyChain(), gridBagConstraints15);
            this.jPanel.add((Component)jLabel5, gridBagConstraints2);
            this.jPanel.add((Component)this.getTxtProxyChainName(), gridBagConstraints3);
            this.jPanel.add((Component)jLabel6, gridBagConstraints41);
            this.jPanel.add((Component)this.getTxtProxyChainPort(), gridBagConstraints51);
            this.jPanel.add((Component)jLabel7, gridBagConstraints61);
            this.jPanel.add((Component)this.getProxyExcludedDomainsPanel(), gridBagConstraints71);
        }
        return this.jPanel;
    }

    private JPanel getPanelProxyAuth() {
        if (this.panelProxyAuth == null) {
            GridBagConstraints gridBagConstraints82 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints72 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints62 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints52 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints42 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            JLabel jLabel11 = new JLabel();
            JLabel jLabel10 = new JLabel();
            JLabel jLabel9 = new JLabel();
            this.panelProxyAuth = new JPanel();
            this.panelProxyAuth.setLayout(new GridBagLayout());
            jLabel9.setText(Constant.messages.getString("conn.options.proxy.auth.realm"));
            jLabel10.setText(Constant.messages.getString("conn.options.proxy.auth.username"));
            jLabel11.setText(Constant.messages.getString("conn.options.proxy.auth.password"));
            this.panelProxyAuth.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("conn.options.proxy.auth.auth"), 0, 0, FontUtils.getFont(FontUtils.Size.standard)));
            gridBagConstraints16.gridx = 0;
            gridBagConstraints16.gridy = 0;
            gridBagConstraints16.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints16.anchor = 18;
            gridBagConstraints16.fill = 2;
            gridBagConstraints16.gridwidth = 2;
            gridBagConstraints16.weightx = 1.0;
            gridBagConstraints17.gridx = 0;
            gridBagConstraints17.gridy = 1;
            gridBagConstraints17.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints17.anchor = 17;
            gridBagConstraints17.fill = 2;
            gridBagConstraints17.gridwidth = 2;
            gridBagConstraints17.weightx = 1.0;
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.gridy = 2;
            gridBagConstraints21.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints21.anchor = 17;
            gridBagConstraints21.fill = 2;
            gridBagConstraints21.weightx = 0.5;
            gridBagConstraints31.gridx = 1;
            gridBagConstraints31.gridy = 2;
            gridBagConstraints31.weightx = 0.5;
            gridBagConstraints31.fill = 2;
            gridBagConstraints31.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints31.anchor = 17;
            gridBagConstraints31.ipadx = 50;
            gridBagConstraints42.gridx = 0;
            gridBagConstraints42.gridy = 3;
            gridBagConstraints42.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints42.fill = 2;
            gridBagConstraints42.weightx = 0.5;
            gridBagConstraints42.anchor = 17;
            gridBagConstraints52.gridx = 1;
            gridBagConstraints52.gridy = 3;
            gridBagConstraints52.weightx = 0.5;
            gridBagConstraints52.fill = 2;
            gridBagConstraints52.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints52.anchor = 17;
            gridBagConstraints52.ipadx = 50;
            gridBagConstraints62.gridx = 0;
            gridBagConstraints62.gridy = 4;
            gridBagConstraints62.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints62.anchor = 17;
            gridBagConstraints62.fill = 2;
            gridBagConstraints62.weightx = 0.5;
            gridBagConstraints72.gridx = 1;
            gridBagConstraints72.gridy = 4;
            gridBagConstraints72.weightx = 0.5;
            gridBagConstraints72.fill = 2;
            gridBagConstraints72.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints72.anchor = 17;
            gridBagConstraints72.ipadx = 50;
            gridBagConstraints82.gridx = 1;
            gridBagConstraints82.gridy = 5;
            gridBagConstraints82.weightx = 0.5;
            gridBagConstraints82.fill = 2;
            gridBagConstraints82.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints82.anchor = 17;
            gridBagConstraints82.ipadx = 50;
            this.panelProxyAuth.add((Component)this.getChkProxyChainAuth(), gridBagConstraints16);
            this.panelProxyAuth.add((Component)this.getChkProxyChainPrompt(), gridBagConstraints17);
            this.panelProxyAuth.add((Component)jLabel9, gridBagConstraints21);
            this.panelProxyAuth.add((Component)this.getTxtProxyChainRealm(), gridBagConstraints31);
            this.panelProxyAuth.add((Component)jLabel10, gridBagConstraints42);
            this.panelProxyAuth.add((Component)this.getTxtProxyChainUserName(), gridBagConstraints52);
            this.panelProxyAuth.add((Component)jLabel11, gridBagConstraints62);
            this.panelProxyAuth.add((Component)this.getTxtProxyChainPassword(), gridBagConstraints72);
            this.panelProxyAuth.add((Component)this.getChkShowPassword(), gridBagConstraints82);
        }
        return this.panelProxyAuth;
    }

    private JPanel getPanelProxyChain() {
        if (this.panelProxyChain == null) {
            this.panelProxyChain = new JPanel(new BorderLayout());
            this.panelProxyChain.setName("ProxyChain");
            JPanel innerPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            innerPanel.add((Component)this.getPanelGeneral(), gbc);
            innerPanel.add((Component)this.getDnsPanel(), gbc);
            innerPanel.add((Component)this.getSecurityProtocolsPanel(), gbc);
            innerPanel.add((Component)this.getJPanel(), gbc);
            innerPanel.add((Component)this.getPanelProxyAuth(), gbc);
            innerPanel.add((Component)this.socksProxyPanel, gbc);
            JScrollPane scrollPane = new JScrollPane(innerPanel);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.panelProxyChain.add((Component)scrollPane, "Center");
        }
        return this.panelProxyChain;
    }

    private JPanel getDnsPanel() {
        if (this.dnsPanel == null) {
            this.dnsPanel = new JPanel();
            this.dnsPanel.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("conn.options.dns.title"), 0, 0, FontUtils.getFont(FontUtils.Size.standard)));
            GroupLayout layout = new GroupLayout(this.dnsPanel);
            this.dnsPanel.setLayout(layout);
            layout.setAutoCreateGaps(true);
            JLabel valueLabel = new JLabel(Constant.messages.getString("conn.options.dns.ttlSuccessfulQueries.label"));
            valueLabel.setToolTipText(Constant.messages.getString("conn.options.dns.ttlSuccessfulQueries.toolTip"));
            valueLabel.setLabelFor(this.getDnsTtlSuccessfulQueriesNumberSpinner());
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(valueLabel).addComponent(this.getDnsTtlSuccessfulQueriesNumberSpinner()));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(valueLabel).addComponent(this.getDnsTtlSuccessfulQueriesNumberSpinner()));
        }
        return this.dnsPanel;
    }

    private ZapNumberSpinner getDnsTtlSuccessfulQueriesNumberSpinner() {
        if (this.dnsTtlSuccessfulQueriesNumberSpinner == null) {
            this.dnsTtlSuccessfulQueriesNumberSpinner = new ZapNumberSpinner(-1, 30, Integer.MAX_VALUE);
        }
        return this.dnsTtlSuccessfulQueriesNumberSpinner;
    }

    private ZapTextField getTxtProxyChainName() {
        if (this.txtProxyChainName == null) {
            this.txtProxyChainName = new ZapTextField();
        }
        return this.txtProxyChainName;
    }

    private ZapPortNumberSpinner getTxtProxyChainPort() {
        if (this.spinnerProxyChainPort == null) {
            this.spinnerProxyChainPort = new ZapPortNumberSpinner(8080);
        }
        return this.spinnerProxyChainPort;
    }

    private JComboBox<String> getCommonUserAgents() {
        if (this.commonUserAgents == null) {
            this.commonUserAgents = new JComboBox<String>(CommonUserAgents.getNames());
            if (this.commonUserAgents.getItemCount() == 0) {
                this.commonUserAgents.setEnabled(false);
            } else {
                this.commonUserAgents.addItem("");
                this.commonUserAgents.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String item = (String)OptionsConnectionPanel.this.commonUserAgents.getSelectedItem();
                        String ua = CommonUserAgents.getStringFromName(item);
                        if (ua != null) {
                            OptionsConnectionPanel.this.getDefaultUserAgent().setText(ua);
                        }
                    }
                });
            }
        }
        return this.commonUserAgents;
    }

    private ZapTextField getDefaultUserAgent() {
        if (this.defaultUserAgent == null) {
            this.defaultUserAgent = new ZapTextField();
            this.defaultUserAgent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsConnectionPanel.this.setUaFromString();
                }
            });
            this.defaultUserAgent.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    OptionsConnectionPanel.this.setUaFromString();
                }
            });
        }
        return this.defaultUserAgent;
    }

    private void setUaFromString() {
        String name = CommonUserAgents.getNameFromString(this.getDefaultUserAgent().getText());
        if (name != null) {
            this.getCommonUserAgents().setSelectedItem(name);
        } else {
            this.getCommonUserAgents().setSelectedItem("");
        }
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("conn.options.title"));
        this.add((Component)this.getPanelProxyChain(), this.getPanelProxyChain().getName());
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam optionsParam = (OptionsParam)obj;
        ConnectionParam connectionParam = optionsParam.getConnectionParam();
        this.spinnerTimeoutInSecs.setValue(connectionParam.getTimeoutInSecs());
        this.checkBoxSingleCookieRequestHeader.setSelected(connectionParam.isSingleCookieRequestHeader());
        this.checkBoxHttpStateEnabled.setSelected(connectionParam.isHttpStateEnabled());
        this.getProxyExcludedDomainsTableModel().setExcludedDomains(connectionParam.getProxyExcludedDomains());
        this.getProxyExcludedDomainsPanel().setRemoveWithoutConfirmation(!connectionParam.isConfirmRemoveProxyExcludedDomain());
        this.chkUseProxyChain.setSelected(connectionParam.isUseProxyChain());
        this.txtProxyChainName.setText(connectionParam.getProxyChainName());
        this.txtProxyChainName.discardAllEdits();
        this.spinnerProxyChainPort.setValue(connectionParam.getProxyChainPort());
        this.chkProxyChainAuth.setSelected(connectionParam.isUseProxyChainAuth());
        this.txtProxyChainRealm.setText(connectionParam.getProxyChainRealm());
        this.txtProxyChainRealm.discardAllEdits();
        this.txtProxyChainUserName.setText(connectionParam.getProxyChainUserName());
        this.txtProxyChainUserName.discardAllEdits();
        this.chkProxyChainPrompt.setSelected(connectionParam.isProxyChainPrompt());
        this.chkShowPassword.setSelected(false);
        this.txtProxyChainPassword.setEchoChar('*');
        this.setProxyChainEnabled(connectionParam.isUseProxyChain());
        if (!connectionParam.isProxyChainPrompt()) {
            this.txtProxyChainPassword.setText(connectionParam.getProxyChainPassword());
        }
        this.dnsTtlSuccessfulQueriesNumberSpinner.setValue(connectionParam.getDnsTtlSuccessfulQueries());
        this.securityProtocolsPanel.setSecurityProtocolsEnabled(connectionParam.getSecurityProtocolsEnabled());
        this.defaultUserAgent.setText(connectionParam.getDefaultUserAgent());
        this.setUaFromString();
        this.socksProxyPanel.initParam(connectionParam);
    }

    private void setProxyChainEnabled(boolean isEnabled) {
        this.txtProxyChainName.setEnabled(isEnabled);
        this.spinnerProxyChainPort.setEnabled(isEnabled);
        this.getProxyExcludedDomainsPanel().setComponentEnabled(isEnabled);
        this.chkProxyChainAuth.setEnabled(isEnabled);
        this.setProxyChainAuthEnabled(isEnabled && this.chkProxyChainAuth.isSelected());
    }

    private void setProxyChainAuthEnabled(boolean isEnabled) {
        this.txtProxyChainRealm.setEnabled(isEnabled);
        this.txtProxyChainUserName.setEnabled(isEnabled);
        this.txtProxyChainPassword.setEnabled(isEnabled);
        this.chkProxyChainPrompt.setEnabled(isEnabled);
        this.chkShowPassword.setEnabled(isEnabled);
        if (this.chkProxyChainPrompt.isSelected()) {
            this.setProxyChainPromptEnabled(true);
        }
    }

    private void setProxyChainPromptEnabled(boolean isEnabled) {
        this.txtProxyChainPassword.setEnabled(!isEnabled);
        this.chkShowPassword.setEnabled(!isEnabled);
    }

    @Override
    public void validateParam(Object obj) throws Exception {
        if (this.chkUseProxyChain.isSelected()) {
            if (this.txtProxyChainName.getText().isEmpty()) {
                this.txtProxyChainName.requestFocus();
                throw new Exception(Constant.messages.getString("conn.options.proxy.address.empty"));
            }
            if (this.chkProxyChainAuth.isSelected() && !this.chkProxyChainPrompt.isSelected() && this.txtProxyChainUserName.getText().isEmpty()) {
                this.txtProxyChainUserName.requestFocus();
                throw new Exception(Constant.messages.getString("conn.options.proxy.username.empty"));
            }
        }
        this.securityProtocolsPanel.validateSecurityProtocols();
        this.socksProxyPanel.validateParam();
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam optionsParam = (OptionsParam)obj;
        ConnectionParam connectionParam = optionsParam.getConnectionParam();
        connectionParam.setProxyChainName(this.txtProxyChainName.getText());
        connectionParam.setProxyChainPort(this.spinnerProxyChainPort.getValue());
        connectionParam.setProxyExcludedDomains(this.getProxyExcludedDomainsTableModel().getElements());
        connectionParam.setConfirmRemoveProxyExcludedDomain(!this.getProxyExcludedDomainsPanel().isRemoveWithoutConfirmation());
        connectionParam.setProxyChainRealm(this.txtProxyChainRealm.getText());
        connectionParam.setProxyChainUserName(this.txtProxyChainUserName.getText());
        connectionParam.setProxyChainPrompt(this.chkProxyChainPrompt.isSelected());
        if (this.chkUseProxyChain.isSelected() && this.chkProxyChainAuth.isSelected() && this.chkProxyChainPrompt.isSelected()) {
            if (View.isInitialised()) {
                ProxyDialog dialog = new ProxyDialog((Frame)View.getSingleton().getMainFrame(), true);
                dialog.init(Model.getSingleton().getOptionsParam());
                dialog.setVisible(true);
            }
        } else {
            connectionParam.setProxyChainPassword(new String(this.txtProxyChainPassword.getPassword()));
        }
        connectionParam.setTimeoutInSecs(this.spinnerTimeoutInSecs.getValue());
        connectionParam.setSingleCookieRequestHeader(this.checkBoxSingleCookieRequestHeader.isSelected());
        connectionParam.setHttpStateEnabled(this.checkBoxHttpStateEnabled.isSelected());
        connectionParam.setUseProxyChain(this.chkUseProxyChain.isSelected());
        connectionParam.setUseProxyChainAuth(this.chkProxyChainAuth.isSelected());
        connectionParam.setDnsTtlSuccessfulQueries(this.dnsTtlSuccessfulQueriesNumberSpinner.getValue());
        connectionParam.setSecurityProtocolsEnabled(this.securityProtocolsPanel.getSelectedProtocols());
        connectionParam.setDefaultUserAgent(this.defaultUserAgent.getText());
        this.socksProxyPanel.saveParam(connectionParam);
    }

    private ZapTextField getTxtProxyChainRealm() {
        if (this.txtProxyChainRealm == null) {
            this.txtProxyChainRealm = new ZapTextField();
        }
        return this.txtProxyChainRealm;
    }

    private ZapTextField getTxtProxyChainUserName() {
        if (this.txtProxyChainUserName == null) {
            this.txtProxyChainUserName = new ZapTextField();
        }
        return this.txtProxyChainUserName;
    }

    private JPasswordField getTxtProxyChainPassword() {
        if (this.txtProxyChainPassword == null) {
            this.txtProxyChainPassword = new JPasswordField();
        }
        return this.txtProxyChainPassword;
    }

    private JCheckBox getChkProxyChainAuth() {
        if (this.chkProxyChainAuth == null) {
            this.chkProxyChainAuth = new JCheckBox();
            this.chkProxyChainAuth.setText(Constant.messages.getString("conn.options.proxy.auth.required"));
            this.chkProxyChainAuth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsConnectionPanel.this.setProxyChainAuthEnabled(OptionsConnectionPanel.this.chkProxyChainAuth.isSelected());
                }
            });
        }
        return this.chkProxyChainAuth;
    }

    private JCheckBox getChkProxyChainPrompt() {
        if (this.chkProxyChainPrompt == null) {
            this.chkProxyChainPrompt = new JCheckBox();
            this.chkProxyChainPrompt.setText(Constant.messages.getString("conn.options.proxy.auth.prompt"));
            this.chkProxyChainPrompt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsConnectionPanel.this.setProxyChainPromptEnabled(OptionsConnectionPanel.this.chkProxyChainPrompt.isSelected());
                }
            });
        }
        return this.chkProxyChainPrompt;
    }

    private JPanel getPanelGeneral() {
        if (this.panelGeneral == null) {
            GridBagConstraints gridBagConstraints01 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints00 = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            this.panelGeneral = new JPanel();
            this.panelGeneral.setLayout(new GridBagLayout());
            jLabel.setText(Constant.messages.getString("conn.options.timeout"));
            jLabel.setLabelFor(this.getTxtTimeoutInSecs());
            this.panelGeneral.setBorder(BorderFactory.createTitledBorder(null, Constant.messages.getString("conn.options.general"), 0, 0, FontUtils.getFont(FontUtils.Size.standard)));
            gridBagConstraints00.gridx = 0;
            gridBagConstraints00.gridy = 0;
            gridBagConstraints00.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints00.anchor = 17;
            gridBagConstraints00.fill = 2;
            gridBagConstraints00.weightx = 0.5;
            gridBagConstraints01.gridx = 1;
            gridBagConstraints01.gridy = 0;
            gridBagConstraints01.weightx = 0.5;
            gridBagConstraints01.fill = 2;
            gridBagConstraints01.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints01.anchor = 17;
            gridBagConstraints01.ipadx = 50;
            this.panelGeneral.add((Component)jLabel, gridBagConstraints00);
            this.panelGeneral.add((Component)this.getTxtTimeoutInSecs(), gridBagConstraints01);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 3;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.anchor = 17;
            JLabel uaLabel = new JLabel(Constant.messages.getString("conn.options.defaultUserAgent"));
            uaLabel.setLabelFor(this.getDefaultUserAgent());
            this.panelGeneral.add((Component)uaLabel, LayoutHelper.getGBC(0, 1, 1, 0.5));
            this.panelGeneral.add(this.getCommonUserAgents(), LayoutHelper.getGBC(1, 1, 1, 0.5, new Insets(2, 2, 2, 2)));
            this.panelGeneral.add((Component)this.getDefaultUserAgent(), LayoutHelper.getGBC(0, 2, 2, 1.0, new Insets(2, 2, 2, 2)));
            this.panelGeneral.add((Component)this.getCheckBoxSingleCookeRequestHeader(), gbc);
            this.panelGeneral.add((Component)this.getCheckBoxHttpStateEnabled(), LayoutHelper.getGBC(0, 4, 3, 1.0, 0.0, 2, new Insets(16, 2, 2, 2)));
        }
        return this.panelGeneral;
    }

    private SecurityProtocolsPanel getSecurityProtocolsPanel() {
        if (this.securityProtocolsPanel == null) {
            this.securityProtocolsPanel = new SecurityProtocolsPanel();
        }
        return this.securityProtocolsPanel;
    }

    private ZapNumberSpinner getTxtTimeoutInSecs() {
        if (this.spinnerTimeoutInSecs == null) {
            this.spinnerTimeoutInSecs = new ZapNumberSpinner(0, 20, Integer.MAX_VALUE);
        }
        return this.spinnerTimeoutInSecs;
    }

    private JCheckBox getCheckBoxSingleCookeRequestHeader() {
        if (this.checkBoxSingleCookieRequestHeader == null) {
            this.checkBoxSingleCookieRequestHeader = new JCheckBox(Constant.messages.getString("conn.options.singleCookieRequestHeader"));
        }
        return this.checkBoxSingleCookieRequestHeader;
    }

    public JCheckBox getCheckBoxHttpStateEnabled() {
        if (this.checkBoxHttpStateEnabled == null) {
            this.checkBoxHttpStateEnabled = new JCheckBox(Constant.messages.getString("conn.options.httpStateEnabled"));
        }
        return this.checkBoxHttpStateEnabled;
    }

    public void setCheckBoxHttpStateEnabled(JCheckBox checkBoxHttpStateEnabled) {
        this.checkBoxHttpStateEnabled = checkBoxHttpStateEnabled;
    }

    private ProxyExcludedDomainsMultipleOptionsPanel getProxyExcludedDomainsPanel() {
        if (this.proxyExcludedDomainsPanel == null) {
            this.proxyExcludedDomainsPanel = new ProxyExcludedDomainsMultipleOptionsPanel(this.getProxyExcludedDomainsTableModel());
        }
        return this.proxyExcludedDomainsPanel;
    }

    private ProxyExcludedDomainsTableModel getProxyExcludedDomainsTableModel() {
        if (this.proxyExcludedDomainsTableModel == null) {
            this.proxyExcludedDomainsTableModel = new ProxyExcludedDomainsTableModel();
        }
        return this.proxyExcludedDomainsTableModel;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.connection";
    }

    private static class ProxyExcludedDomainsMultipleOptionsPanel
    extends AbstractMultipleOptionsTablePanel<DomainMatcher> {
        private static final long serialVersionUID = 2332044353650231701L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("conn.options.proxy.excluded.domain.dialog.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("conn.options.proxy.excluded.domain.dialog.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("conn.options.proxy.excluded.domain.dialog.remove.button.confirm");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("conn.options.proxy.excluded.domain.dialog.remove.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("conn.options.proxy.excluded.domain.dialog.remove.checkbox.label");
        private DialogAddProxyExcludedDomain addDialog = null;
        private DialogModifyProxyExcludedDomain modifyDialog = null;

        public ProxyExcludedDomainsMultipleOptionsPanel(ProxyExcludedDomainsTableModel model) {
            super(model);
            this.getTable().setVisibleRowCount(5);
            this.getTable().setSortOrder(2, SortOrder.ASCENDING);
        }

        @Override
        public DomainMatcher showAddDialogue() {
            if (this.addDialog == null) {
                this.addDialog = new DialogAddProxyExcludedDomain(View.getSingleton().getOptionsDialog(null));
                this.addDialog.pack();
            }
            this.addDialog.setVisible(true);
            DomainMatcher hostAuthentication = this.addDialog.getProxyExcludedDomain();
            this.addDialog.clear();
            return hostAuthentication;
        }

        @Override
        public DomainMatcher showModifyDialogue(DomainMatcher e) {
            if (this.modifyDialog == null) {
                this.modifyDialog = new DialogModifyProxyExcludedDomain(View.getSingleton().getOptionsDialog(null));
                this.modifyDialog.pack();
            }
            this.modifyDialog.setProxyExcludedDomain(e);
            this.modifyDialog.setVisible(true);
            DomainMatcher excludedDomain = this.modifyDialog.getProxyExcludedDomain();
            this.modifyDialog.clear();
            if (!excludedDomain.equals(e)) {
                return excludedDomain;
            }
            return null;
        }

        @Override
        public boolean showRemoveDialogue(DomainMatcher e) {
            JCheckBox removeWithoutConfirmationCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] messages = new Object[]{REMOVE_DIALOG_TEXT, " ", removeWithoutConfirmationCheckBox};
            int option = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), messages, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            if (option == 0) {
                this.setRemoveWithoutConfirmation(removeWithoutConfirmationCheckBox.isSelected());
                return true;
            }
            return false;
        }
    }
}

