/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPRootObject;
import ca.sqlpower.architect.olap.SchemaWatcher;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sqlobject.SQLDatabase;
import java.util.Collections;
import java.util.List;

public class OLAPSession
extends OLAPObject {
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.singletonList(MondrianModel.Schema.class);
    private SQLDatabase database;
    private final MondrianModel.Schema schema;
    private final SchemaWatcher schemaWatcher;

    @Constructor
    public OLAPSession(@ConstructorParameter(parameterType=ConstructorParameter.ParameterType.CHILD, propertyName="schema") MondrianModel.Schema schema) {
        this.setName("New Session");
        if (schema.getParent() != null) {
            throw new IllegalStateException("The given schema already belongs to an OLAP Session");
        }
        schema.setParent((SPObject)this);
        this.schema = schema;
        this.schemaWatcher = new SchemaWatcher(schema);
    }

    @Accessor
    public SQLDatabase getDatabase() {
        return this.database;
    }

    @Mutator
    public void setDatabase(SQLDatabase database) {
        SQLDatabase oldDB = this.database;
        this.database = database;
        this.firePropertyChange("database", oldDB, database);
    }

    @NonProperty
    public MondrianModel.Schema getSchema() {
        return this.schema;
    }

    public boolean allowsChildren() {
        return true;
    }

    @NonProperty
    public List<MondrianModel.Schema> getChildren() {
        return Collections.singletonList(this.schema);
    }

    @Override
    public void addChildImpl(SPObject child, int index) {
        throw new UnsupportedOperationException("OLAPSession has exactly one child (the Schema) for its entire lifetime");
    }

    @Override
    public boolean removeChildImpl(SPObject child) {
        throw new UnsupportedOperationException("OLAPSession has exactly one child (the Schema) for its entire lifetime");
    }

    @Override
    public int childPositionOffset(Class<? extends SPObject> childType) {
        if (MondrianModel.Schema.class.equals(childType)) {
            return 0;
        }
        throw new IllegalArgumentException("Child type " + childType + " is not a valid child type of " + OLAPSession.class);
    }

    @Transient
    @Accessor
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    @Transient
    @Accessor
    public List<? extends SPObject> getDependencies() {
        return Collections.singletonList(this.database);
    }

    public void removeDependency(SPObject dependency) {
        this.getParent().removeOLAPSession(this);
    }

    @Mutator
    public void setParent(SPObject parent) {
        if (parent != null && !(parent instanceof OLAPRootObject)) {
            throw new IllegalArgumentException("The parent of " + OLAPSession.class + "s are " + OLAPRootObject.class + "s not " + parent);
        }
        super.setParent(parent);
    }

    @Accessor
    public OLAPRootObject getParent() {
        return (OLAPRootObject)super.getParent();
    }
}

