/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.message.BufferedHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EncodingUtils;

public class BasicScheme
extends RFC2617Scheme {
    private static final long serialVersionUID = -1931571557597830536L;
    private boolean complete;

    public BasicScheme(Charset credentialsCharset) {
        super(credentialsCharset);
        this.complete = false;
    }

    @Deprecated
    public BasicScheme(ChallengeState challengeState) {
        super(challengeState);
    }

    public BasicScheme() {
        this(Consts.ASCII);
    }

    @Override
    public String getSchemeName() {
        return "basic";
    }

    @Override
    public void processChallenge(Header header) throws MalformedChallengeException {
        super.processChallenge(header);
        this.complete = true;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    @Override
    @Deprecated
    public Header authenticate(Credentials credentials2, HttpRequest request) throws AuthenticationException {
        return this.authenticate(credentials2, request, new BasicHttpContext());
    }

    @Override
    public Header authenticate(Credentials credentials2, HttpRequest request, HttpContext context) throws AuthenticationException {
        Args.notNull(credentials2, "Credentials");
        Args.notNull(request, "HTTP request");
        StringBuilder tmp = new StringBuilder();
        tmp.append(credentials2.getUserPrincipal().getName());
        tmp.append(":");
        tmp.append(credentials2.getPassword() == null ? "null" : credentials2.getPassword());
        Base64 base64codec = new Base64(0);
        byte[] base64password = base64codec.encode(EncodingUtils.getBytes(tmp.toString(), this.getCredentialsCharset(request)));
        CharArrayBuffer buffer2 = new CharArrayBuffer(32);
        if (this.isProxy()) {
            buffer2.append("Proxy-Authorization");
        } else {
            buffer2.append("Authorization");
        }
        buffer2.append(": Basic ");
        buffer2.append(base64password, 0, base64password.length);
        return new BufferedHeader(buffer2);
    }

    @Deprecated
    public static Header authenticate(Credentials credentials2, String charset, boolean proxy2) {
        Args.notNull(credentials2, "Credentials");
        Args.notNull(charset, "charset");
        StringBuilder tmp = new StringBuilder();
        tmp.append(credentials2.getUserPrincipal().getName());
        tmp.append(":");
        tmp.append(credentials2.getPassword() == null ? "null" : credentials2.getPassword());
        byte[] base64password = Base64.encodeBase64(EncodingUtils.getBytes(tmp.toString(), charset), false);
        CharArrayBuffer buffer2 = new CharArrayBuffer(32);
        if (proxy2) {
            buffer2.append("Proxy-Authorization");
        } else {
            buffer2.append("Authorization");
        }
        buffer2.append(": Basic ");
        buffer2.append(base64password, 0, base64password.length);
        return new BufferedHeader(buffer2);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BASIC [complete=").append(this.complete).append("]");
        return builder.toString();
    }
}

