/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.vmconversion;

import com.amazon.aes.webservices.client.vmconversionschema.Part;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.NoSuchAlgorithmException;

public class Slice {
    private final File sourceFile;
    private final Part part;
    private File file = null;

    public Slice(File sourceFile, Part part) throws IOException, NoSuchAlgorithmException {
        this.sourceFile = sourceFile;
        this.part = part;
        this.sliceOutPart();
    }

    public PutObjectRequest createPutObjectRequest(String bucketName) {
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, this.part.getKey(), this.file);
        return putObjectRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sliceOutPart() throws IOException, NoSuchAlgorithmException {
        this.file = File.createTempFile(this.sourceFile.getName(), ".part" + this.part.getIndex());
        this.file.deleteOnExit();
        byte[] buff = new byte[65536];
        RandomAccessFile input = null;
        FileOutputStream outputStream = null;
        try {
            int bytesRead;
            input = new RandomAccessFile(this.sourceFile, "r");
            input.seek(this.part.getByteRange().getStart());
            outputStream = new FileOutputStream(this.file);
            for (long sliceBytesToRead = this.part.getByteRange().getEnd() - this.part.getByteRange().getStart() + 1L; sliceBytesToRead > 0L; sliceBytesToRead -= (long)bytesRead) {
                int bytesToRead = sliceBytesToRead > (long)buff.length ? buff.length : (int)sliceBytesToRead;
                bytesRead = input.read(buff, 0, bytesToRead);
                if (bytesRead == -1) {
                    throw new RuntimeException("Premature end of slice reached");
                }
                outputStream.write(buff, 0, bytesRead);
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public void deleteFile() {
        this.file.delete();
        this.file = null;
    }
}

