/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.report;

import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.label.MarketLabel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.report.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.CollectionUtils;

public final class ReportTradePanel
extends ReportPanel {
    private final List<Colony> colonies;

    /*
     * WARNING - void declaration
     */
    public ReportTradePanel(FreeColClient freeColClient) {
        super(freeColClient, "reportTradeAction");
        void var17_22;
        Player player = this.getMyPlayer();
        Color warnColor = ImageLibrary.getColor("color.report.trade.warn");
        this.colonies = player.getColonyList();
        MigPanel goodsHeader = new MigPanel("ReportPanelUI");
        goodsHeader.setBorder(new EmptyBorder(20, 20, 0, 20));
        this.scrollPane.setColumnHeaderView(goodsHeader);
        Specification spec = this.getSpecification();
        List<GoodsType> storableGoods = spec.getStorableGoodsTypeList();
        Market market = player.getMarket();
        this.reportPanel.removeAll();
        goodsHeader.removeAll();
        String layoutConstraints = "insets 0, gap 0 0";
        String columnConstraints = "[25%!, fill][" + (int)Math.round((double)ImageLibrary.ICON_SIZE.width * 1.25) + "!, fill]";
        String rowConstraints = "[fill]";
        this.reportPanel.setLayout(new MigLayout(layoutConstraints, columnConstraints, rowConstraints));
        goodsHeader.setLayout(new MigLayout(layoutConstraints, columnConstraints, rowConstraints));
        goodsHeader.setOpaque(true);
        JLabel emptyLabel = new JLabel();
        emptyLabel.setBorder(Utility.getTopLeftCellBorder());
        goodsHeader.add((Component)emptyLabel, "cell 0 0");
        JLabel jl = this.createLeftLabel("report.trade.unitsSold");
        jl.setBorder(Utility.getTopLeftCellBorder());
        this.reportPanel.add((Component)jl, "cell 0 0");
        this.reportPanel.add((Component)this.createLeftLabel("report.trade.beforeTaxes"), "cell 0 1");
        this.reportPanel.add((Component)this.createLeftLabel("report.trade.afterTaxes"), "cell 0 2");
        this.reportPanel.add((Component)this.createLeftLabel("report.trade.cargoUnits"), "cell 0 3");
        this.reportPanel.add((Component)this.createLeftLabel("report.trade.totalUnits"), "cell 0 4");
        this.reportPanel.add((Component)this.createLeftLabel("report.trade.totalDelta"), "cell 0 5");
        TypeCountMap<GoodsType> totalUnits = new TypeCountMap<GoodsType>();
        TypeCountMap<GoodsType> deltaUnits = new TypeCountMap<GoodsType>();
        TypeCountMap<GoodsType> cargoUnits = new TypeCountMap<GoodsType>();
        for (Unit unit : CollectionUtils.transform(player.getUnits(), Unit::isCarrier)) {
            for (Goods goods : unit.getCompactGoodsList()) {
                cargoUnits.incrementCount(goods.getType(), goods.getAmount());
                totalUnits.incrementCount(goods.getType(), goods.getAmount());
            }
        }
        int column = 0;
        for (GoodsType goodsType : storableGoods) {
            ++column;
            int sales = player.getSales(goodsType);
            int beforeTaxes = player.getIncomeBeforeTaxes(goodsType);
            int afterTaxes = player.getIncomeAfterTaxes(goodsType);
            goodsHeader.add(new MarketLabel(freeColClient, goodsType, market).addBorder());
            jl = this.createNumberLabel(sales);
            jl.setBorder(Utility.getTopCellBorder());
            this.reportPanel.add((Component)jl, "cell " + column + " 0");
            this.reportPanel.add((Component)this.createNumberLabel(beforeTaxes), "cell " + column + " 1");
            this.reportPanel.add((Component)this.createNumberLabel(afterTaxes), "cell " + column + " 2");
            this.reportPanel.add((Component)this.createNumberLabel(cargoUnits.getCount(goodsType)), "cell " + column + " 3");
        }
        int n = 6;
        boolean first = true;
        for (Colony colony : this.colonies) {
            void var17_21;
            for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
                deltaUnits.incrementCount(goodsType, colony.getNetProductionOf(goodsType));
            }
            for (Goods goods : colony.getCompactGoodsList()) {
                totalUnits.incrementCount(goods.getType(), goods.getAmount());
            }
            JButton colonyButton = this.createColonyButton(colony);
            if (colony.hasAbility("model.ability.export")) {
                colonyButton.setText(colonyButton.getText() + "*");
            }
            colonyButton.setBorder(first ? Utility.getTopLeftCellBorder() : Utility.getLeftCellBorder());
            this.reportPanel.add((Component)colonyButton, "cell 0 " + (int)var17_21 + " 1 2");
            column = 0;
            for (GoodsType goodsType : storableGoods) {
                ++column;
                int amount = colony.getGoodsCount(goodsType);
                JLabel goodsLabel = new JLabel(String.valueOf(amount), 11);
                goodsLabel.setBorder(first ? Utility.getTopCellBorder() : Utility.getCellBorder());
                goodsLabel.setForeground(ImageLibrary.getGoodsColor(goodsType, amount, colony));
                ExportData ed = colony.getExportData(goodsType);
                if (ed.getExported()) {
                    goodsLabel.setToolTipText(Messages.message(((StringTemplate)StringTemplate.template("report.trade.export").addNamed("%goods%", goodsType)).addAmount("%amount%", ed.getExportLevel())));
                }
                this.reportPanel.add((Component)goodsLabel, "cell " + column + " " + (int)var17_21);
                int production = colony.getNetProductionOf(goodsType);
                JLabel productionLabel = this.createNumberLabel(production, true);
                productionLabel.setForeground(ImageLibrary.getGoodsColor(goodsType, production, colony));
                Collection<StringTemplate> warnings = colony.getProductionWarnings(goodsType);
                if (!warnings.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (StringTemplate warning : warnings) {
                        sb.append(Messages.message(warning)).append(' ');
                    }
                    sb.setLength(sb.length() - 1);
                    productionLabel.setToolTipText(sb.toString());
                    productionLabel.setForeground(warnColor);
                }
                this.reportPanel.add((Component)productionLabel, "cell " + column + " " + (int)(var17_21 + true));
            }
            var17_21 += 2;
            first = false;
        }
        this.reportPanel.add((Component)Utility.localizedLabel("report.trade.hasCustomHouse"), "cell 0 " + (int)(++var17_22) + ", span");
        column = 0;
        for (GoodsType goodsType : storableGoods) {
            this.reportPanel.add((Component)this.createNumberLabel(totalUnits.getCount(goodsType)), "cell " + ++column + " 4");
            this.reportPanel.add((Component)this.createNumberLabel(deltaUnits.getCount(goodsType), true), "cell " + column + " 5, wrap 20");
        }
    }

    private JLabel createLeftLabel(String key) {
        JLabel result = Utility.localizedLabel(key);
        result.setBorder(Utility.getLeftCellBorder());
        return result;
    }

    private JLabel createNumberLabel(int value) {
        return this.createNumberLabel(value, false);
    }

    private JLabel createNumberLabel(int value, boolean alwaysAddSign) {
        JLabel result = new JLabel(String.valueOf(value), 11);
        result.setBorder(Utility.getCellBorder());
        if (value < 0) {
            result.setForeground(Color.RED);
        } else if (alwaysAddSign && value > 0) {
            result.setText("+" + value);
        }
        return result;
    }
}

