/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.util.Utils;

public class InciteTradeItem
extends TradeItem {
    public static final String TAG = "inciteTradeItem";
    private Player victim;
    private static final String VICTIM_TAG = "victim";

    public InciteTradeItem(Game game, Player source, Player destination, Player victim) {
        super(game, Messages.nameKey("model.tradeItem.incite"), source, destination);
        this.victim = victim;
    }

    public InciteTradeItem(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(game, xr);
    }

    @Override
    public boolean isValid() {
        return this.victim != null && this.victim != this.getSource() && this.victim != this.getDestination();
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public StringTemplate getLabel() {
        return StringTemplate.template(Messages.descriptionKey("model.tradeItem.incite")).addStringTemplate("%nation%", this.victim.getNationLabel());
    }

    @Override
    public Player getVictim() {
        return this.victim;
    }

    @Override
    public int evaluateFor(Player player) {
        Player victim = this.getVictim();
        switch (player.getStance(victim)) {
            case ALLIANCE: {
                return Integer.MIN_VALUE;
            }
            case WAR: {
                return 0;
            }
        }
        return -((int)Math.round(50.0 / player.getStrengthRatio(victim, false)));
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        InciteTradeItem o = this.copyInCast(other, InciteTradeItem.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.victim = this.getGame().updateRef(o.getVictim());
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(VICTIM_TAG, this.victim);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.victim = xr.findFreeColGameObject(this.getGame(), VICTIM_TAG, Player.class, null, true);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof InciteTradeItem)) {
            return false;
        }
        InciteTradeItem other = (InciteTradeItem)o;
        return Utils.equals(this.victim, other.victim) && super.equals(other);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return 37 * hash + Utils.hashCode(this.victim);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append('[').append(this.getId()).append(' ').append(this.victim.getId()).append(']');
        return sb.toString();
    }
}

