/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.GlobData;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.regexp.SubString;

public class RegExpImpl
implements RegExpProxy {
    String input;
    boolean multiline;
    SubString[] parens;
    SubString lastMatch;
    SubString lastParen;
    SubString leftContext;
    SubString rightContext;

    public boolean isRegExp(Scriptable scriptable) {
        return scriptable instanceof NativeRegExp;
    }

    public Object compileRegExp(Context context, String string, String string2) {
        return NativeRegExp.compileRE(context, string, string2, false);
    }

    public Scriptable wrapRegExp(Context context, Scriptable scriptable, Object object) {
        return new NativeRegExp(scriptable, object);
    }

    public Object action(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, int n) {
        GlobData globData = new GlobData();
        globData.mode = n;
        switch (n) {
            case 1: {
                globData.optarg = 1;
                Object object = RegExpImpl.matchOrReplace(context, scriptable, scriptable2, objectArray, this, globData, false);
                return globData.arrayobj == null ? object : globData.arrayobj;
            }
            case 3: {
                globData.optarg = 1;
                return RegExpImpl.matchOrReplace(context, scriptable, scriptable2, objectArray, this, globData, false);
            }
            case 2: {
                Object object = objectArray.length < 2 ? Undefined.instance : objectArray[1];
                String string = null;
                Function function = null;
                if (object instanceof Function) {
                    function = (Function)object;
                } else {
                    string = ScriptRuntime.toString(object);
                }
                globData.optarg = 2;
                globData.lambda = function;
                globData.repstr = string;
                globData.dollar = string == null ? -1 : string.indexOf(36);
                globData.charBuf = null;
                globData.leftIndex = 0;
                Object object2 = RegExpImpl.matchOrReplace(context, scriptable, scriptable2, objectArray, this, globData, true);
                SubString subString = this.rightContext;
                if (globData.charBuf == null) {
                    if (globData.global || object2 == null || !object2.equals(Boolean.TRUE)) {
                        return globData.str;
                    }
                    SubString subString2 = this.leftContext;
                    RegExpImpl.replace_glob(globData, context, scriptable, this, subString2.index, subString2.length);
                }
                globData.charBuf.append(subString.charArray, subString.index, subString.length);
                return globData.charBuf.toString();
            }
        }
        throw Kit.codeBug();
    }

    private static Object matchOrReplace(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, RegExpImpl regExpImpl, GlobData globData, boolean bl) {
        Object object;
        NativeRegExp nativeRegExp;
        Object object2;
        String string;
        globData.str = string = ScriptRuntime.toString(scriptable2);
        Scriptable scriptable3 = ScriptableObject.getTopLevelScope(scriptable);
        if (objectArray.length == 0) {
            object2 = NativeRegExp.compileRE(context, "", "", false);
            nativeRegExp = new NativeRegExp(scriptable3, object2);
        } else if (objectArray[0] instanceof NativeRegExp) {
            nativeRegExp = (NativeRegExp)objectArray[0];
        } else {
            object2 = ScriptRuntime.toString(objectArray[0]);
            if (globData.optarg < objectArray.length) {
                objectArray[0] = object2;
                object = ScriptRuntime.toString(objectArray[globData.optarg]);
            } else {
                object = null;
            }
            Object object3 = NativeRegExp.compileRE(context, (String)object2, object, bl);
            nativeRegExp = new NativeRegExp(scriptable3, object3);
        }
        globData.regexp = nativeRegExp;
        globData.global = (nativeRegExp.getFlags() & 1) != 0;
        object2 = new int[1];
        object = null;
        if (globData.mode == 3) {
            object = nativeRegExp.executeRegExp(context, scriptable, regExpImpl, string, (int[])object2, 0);
            object = object != null && object.equals(Boolean.TRUE) ? new Integer(regExpImpl.leftContext.length) : new Integer(-1);
        } else if (globData.global) {
            nativeRegExp.lastIndex = 0.0;
            int n = 0;
            while (object2[0] <= string.length()) {
                object = nativeRegExp.executeRegExp(context, scriptable, regExpImpl, string, (int[])object2, 0);
                if (object == null || !object.equals(Boolean.TRUE)) break;
                if (globData.mode == 1) {
                    RegExpImpl.match_glob(globData, context, scriptable, n, regExpImpl);
                } else {
                    if (globData.mode != 2) {
                        Kit.codeBug();
                    }
                    SubString subString = regExpImpl.lastMatch;
                    int n2 = globData.leftIndex;
                    int n3 = subString.index - n2;
                    globData.leftIndex = subString.index + subString.length;
                    RegExpImpl.replace_glob(globData, context, scriptable, regExpImpl, n2, n3);
                }
                if (regExpImpl.lastMatch.length == 0) {
                    if (object2[0] == string.length()) break;
                    Object object4 = object2;
                    object4[0] = object4[0] + true;
                }
                ++n;
            }
        } else {
            object = nativeRegExp.executeRegExp(context, scriptable, regExpImpl, string, (int[])object2, globData.mode == 2 ? 0 : 1);
        }
        return object;
    }

    public int find_split(Context context, Scriptable scriptable, String string, String string2, Scriptable scriptable2, int[] nArray, int[] nArray2, boolean[] blArray, String[][] stringArray) {
        int n;
        SubString subString;
        int n2;
        block6: {
            int n3;
            block5: {
                n3 = nArray[0];
                int n4 = string.length();
                int n5 = context.getLanguageVersion();
                NativeRegExp nativeRegExp = (NativeRegExp)scriptable2;
                do {
                    n2 = nArray[0];
                    nArray[0] = ++n3;
                    Object object = nativeRegExp.executeRegExp(context, scriptable, this, string, nArray, 0);
                    if (object != Boolean.TRUE) {
                        nArray[0] = n2;
                        nArray2[0] = 1;
                        blArray[0] = false;
                        return n4;
                    }
                    n3 = nArray[0];
                    nArray[0] = n2;
                    blArray[0] = true;
                    subString = this.lastMatch;
                    nArray2[0] = subString.length;
                    if (nArray2[0] != 0 || n3 != nArray[0]) break block5;
                } while (n3 != n4);
                if (n5 == 120) {
                    nArray2[0] = 1;
                    n = n3;
                } else {
                    n = -1;
                }
                break block6;
            }
            n = n3 - nArray2[0];
        }
        n2 = this.parens == null ? 0 : this.parens.length;
        stringArray[0] = new String[n2];
        int n6 = 0;
        while (n6 < n2) {
            subString = this.getParenSubString(n6);
            stringArray[0][n6] = subString.toString();
            ++n6;
        }
        return n;
    }

    SubString getParenSubString(int n) {
        SubString subString;
        if (this.parens != null && n < this.parens.length && (subString = this.parens[n]) != null) {
            return subString;
        }
        return SubString.emptySubString;
    }

    private static void match_glob(GlobData globData, Context context, Scriptable scriptable, int n, RegExpImpl regExpImpl) {
        Object object;
        if (globData.arrayobj == null) {
            object = ScriptableObject.getTopLevelScope(scriptable);
            globData.arrayobj = ScriptRuntime.newObject(context, (Scriptable)object, "Array", null);
        }
        object = regExpImpl.lastMatch;
        String string = ((SubString)object).toString();
        globData.arrayobj.put(n, globData.arrayobj, (Object)string);
    }

    private static void replace_glob(GlobData globData, Context context, Scriptable scriptable, RegExpImpl regExpImpl, int n, int n2) {
        int n3;
        String string;
        int n4;
        Object[] objectArray;
        if (globData.lambda != null) {
            Object object;
            objectArray = regExpImpl.parens;
            n4 = objectArray == null ? 0 : objectArray.length;
            Object[] objectArray2 = new Object[n4 + 3];
            objectArray2[0] = regExpImpl.lastMatch.toString();
            int n5 = 0;
            while (n5 < n4) {
                object = objectArray[n5];
                objectArray2[n5 + 1] = object != null ? ((SubString)object).toString() : Undefined.instance;
                ++n5;
            }
            objectArray2[n4 + 1] = new Integer(regExpImpl.leftContext.length);
            objectArray2[n4 + 2] = globData.str;
            if (regExpImpl != ScriptRuntime.getRegExpProxy(context)) {
                Kit.codeBug();
            }
            RegExpImpl regExpImpl2 = new RegExpImpl();
            regExpImpl2.multiline = regExpImpl.multiline;
            regExpImpl2.input = regExpImpl.input;
            ScriptRuntime.setRegExpProxy(context, regExpImpl2);
            try {
                object = ScriptableObject.getTopLevelScope(scriptable);
                Object object2 = globData.lambda.call(context, (Scriptable)object, (Scriptable)object, objectArray2);
                string = ScriptRuntime.toString(object2);
            }
            finally {
                ScriptRuntime.setRegExpProxy(context, regExpImpl);
            }
            n3 = string.length();
        } else {
            string = null;
            n3 = globData.repstr.length();
            if (globData.dollar >= 0) {
                objectArray = new int[1];
                n4 = globData.dollar;
                do {
                    SubString subString;
                    if ((subString = RegExpImpl.interpretDollar(context, regExpImpl, globData.repstr, n4, (int[])objectArray)) != null) {
                        n3 += subString.length - objectArray[0];
                        n4 += objectArray[0];
                        continue;
                    }
                    ++n4;
                } while ((n4 = globData.repstr.indexOf(36, n4)) >= 0);
            }
        }
        int n6 = n2 + n3 + regExpImpl.rightContext.length;
        StringBuffer stringBuffer = globData.charBuf;
        if (stringBuffer == null) {
            globData.charBuf = stringBuffer = new StringBuffer(n6);
        } else {
            stringBuffer.ensureCapacity(globData.charBuf.length() + n6);
        }
        stringBuffer.append(regExpImpl.leftContext.charArray, n, n2);
        if (globData.lambda != null) {
            stringBuffer.append(string);
        } else {
            RegExpImpl.do_replace(globData, context, regExpImpl);
        }
    }

    private static SubString interpretDollar(Context context, RegExpImpl regExpImpl, String string, int n, int[] nArray) {
        int n2;
        if (string.charAt(n) != '$') {
            Kit.codeBug();
        }
        if ((n2 = context.getLanguageVersion()) != 0 && n2 <= 140 && n > 0 && string.charAt(n - 1) == '\\') {
            return null;
        }
        int n3 = string.length();
        if (n + 1 >= n3) {
            return null;
        }
        char c = string.charAt(n + 1);
        if (NativeRegExp.isDigit(c)) {
            int n4;
            int n5;
            int n6;
            if (n2 != 0 && n2 <= 140) {
                if (c == '0') {
                    return null;
                }
                n6 = 0;
                n5 = n;
                while (++n5 < n3 && NativeRegExp.isDigit(c = string.charAt(n5))) {
                    n4 = 10 * n6 + (c - 48);
                    if (n4 >= n6) {
                        n6 = n4;
                        continue;
                    }
                    break;
                }
            } else {
                n6 = c - 48;
                int n7 = regExpImpl.parens == null ? 0 : regExpImpl.parens.length;
                if (n6 > n7) {
                    return null;
                }
                n5 = n + 2;
                if (n + 2 < n3 && NativeRegExp.isDigit(c = string.charAt(n + 2)) && (n4 = 10 * n6 + (c - 48)) <= n7) {
                    ++n5;
                    n6 = n4;
                }
                if (n6 == 0) {
                    return null;
                }
            }
            nArray[0] = n5 - n;
            return regExpImpl.getParenSubString(--n6);
        }
        nArray[0] = 2;
        switch (c) {
            case '$': {
                return new SubString("$");
            }
            case '&': {
                return regExpImpl.lastMatch;
            }
            case '+': {
                return regExpImpl.lastParen;
            }
            case '`': {
                if (n2 == 120) {
                    regExpImpl.leftContext.index = 0;
                    regExpImpl.leftContext.length = regExpImpl.lastMatch.index;
                }
                return regExpImpl.leftContext;
            }
            case '\'': {
                return regExpImpl.rightContext;
            }
        }
        return null;
    }

    private static void do_replace(GlobData globData, Context context, RegExpImpl regExpImpl) {
        int n;
        StringBuffer stringBuffer = globData.charBuf;
        int n2 = 0;
        String string = globData.repstr;
        int n3 = globData.dollar;
        if (n3 != -1) {
            int[] nArray = new int[1];
            do {
                int n4 = n3 - n2;
                stringBuffer.append(string.substring(n2, n3));
                n2 = n3;
                SubString subString = RegExpImpl.interpretDollar(context, regExpImpl, string, n3, nArray);
                if (subString != null) {
                    n4 = subString.length;
                    if (n4 > 0) {
                        stringBuffer.append(subString.charArray, subString.index, n4);
                    }
                    n2 += nArray[0];
                    n3 += nArray[0];
                    continue;
                }
                ++n3;
            } while ((n3 = string.indexOf(36, n3)) >= 0);
        }
        if ((n = string.length()) > n2) {
            stringBuffer.append(string.substring(n2, n));
        }
    }
}

