/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayDeque;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import org.apache.commons.lang.reflect.MethodUtils;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.ClassInspector;
import org.gradle.internal.reflect.NoSuchPropertyException;
import org.gradle.internal.reflect.PropertyAccessor;
import org.gradle.internal.reflect.PropertyAccessorType;
import org.gradle.internal.reflect.PropertyMutator;
import org.gradle.util.internal.CollectionUtils;

public class JavaPropertyReflectionUtil {
    private static final WeakHashMap<Class<?>, Set<String>> PROPERTY_CACHE = new WeakHashMap();

    public static <T, F> PropertyAccessor<T, F> readableProperty(Class<T> target, Class<F> returnType, String property) throws NoSuchPropertyException {
        Method getterMethod = JavaPropertyReflectionUtil.findGetterMethod(target, property);
        if (getterMethod == null) {
            throw new NoSuchPropertyException(String.format("Could not find getter method for property '%s' on class %s.", property, target.getSimpleName()));
        }
        return new GetterMethodBackedPropertyAccessor(property, returnType, getterMethod);
    }

    public static <T, F> PropertyAccessor<T, F> readableProperty(T target, Class<F> returnType, String property) throws NoSuchPropertyException {
        Class<?> targetClass = target.getClass();
        return JavaPropertyReflectionUtil.readableProperty(targetClass, returnType, property);
    }

    @Nullable
    public static Method findGetterMethod(Class<?> target, String property) {
        Method[] methods = target.getMethods();
        String getter = JavaPropertyReflectionUtil.toMethodName("get", property);
        String iser = JavaPropertyReflectionUtil.toMethodName("is", property);
        for (Method method : methods) {
            String methodName = method.getName();
            if (getter.equals(methodName) && PropertyAccessorType.of(method) == PropertyAccessorType.GET_GETTER) {
                return method;
            }
            if (!iser.equals(methodName) || PropertyAccessorType.of(method) != PropertyAccessorType.IS_GETTER) continue;
            return method;
        }
        return null;
    }

    public static PropertyMutator writeableProperty(Class<?> target, String property, @Nullable Class<?> valueType) throws NoSuchPropertyException {
        PropertyMutator mutator = JavaPropertyReflectionUtil.writeablePropertyIfExists(target, property, valueType);
        if (mutator != null) {
            return mutator;
        }
        throw new NoSuchPropertyException(String.format("Could not find setter method for property '%s' %s on class %s.", property, valueType == null ? "accepting null value" : "of type " + valueType.getSimpleName(), target.getSimpleName()));
    }

    @Nullable
    public static PropertyMutator writeablePropertyIfExists(Class<?> target, String property, @Nullable Class<?> valueType) throws NoSuchPropertyException {
        String setterName = JavaPropertyReflectionUtil.toMethodName("set", property);
        Method method = MethodUtils.getMatchingAccessibleMethod(target, (String)setterName, (Class[])new Class[]{valueType});
        if (method != null) {
            return new MethodBackedPropertyMutator(property, method);
        }
        return null;
    }

    private static String toMethodName(String prefix, String propertyName) {
        assert (!propertyName.isEmpty());
        return prefix + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> propertyNames(Object target) {
        Class<?> targetType = target.getClass();
        WeakHashMap<Class<?>, Set<String>> weakHashMap = PROPERTY_CACHE;
        synchronized (weakHashMap) {
            Set<String> cached = PROPERTY_CACHE.get(targetType);
            if (cached == null) {
                cached = ClassInspector.inspect(targetType).getPropertyNames();
                PROPERTY_CACHE.put(targetType, cached);
            }
            return cached;
        }
    }

    @Nullable
    public static <A extends Annotation> A getAnnotation(Class<?> type, Class<A> annotationType) {
        return JavaPropertyReflectionUtil.getAnnotation(type, annotationType, true);
    }

    @Nullable
    private static <A extends Annotation> A getAnnotation(Class<?> type, Class<A> annotationType, boolean checkType) {
        A annotation;
        if (checkType && (annotation = type.getAnnotation(annotationType)) != null) {
            return annotation;
        }
        if (annotationType.getAnnotation(Inherited.class) != null) {
            for (Class<?> anInterface : type.getInterfaces()) {
                annotation = JavaPropertyReflectionUtil.getAnnotation(anInterface, annotationType, true);
                if (annotation == null) continue;
                return annotation;
            }
        }
        if (type.isInterface() || type.equals(Object.class)) {
            return null;
        }
        return JavaPropertyReflectionUtil.getAnnotation(type.getSuperclass(), annotationType, false);
    }

    public static boolean hasDefaultToString(Object object) {
        try {
            return object.getClass().getMethod("toString", new Class[0]).getDeclaringClass() == Object.class;
        }
        catch (NoSuchMethodException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public static <T> Type resolveMethodReturnType(Class<T> type, Method method) {
        Type returnType = method.getGenericReturnType();
        if (type.equals(method.getDeclaringClass())) {
            return returnType;
        }
        return JavaPropertyReflectionUtil.hasTypeVariable(returnType) ? TypeToken.of(type).method(method).getReturnType().getType() : returnType;
    }

    public static boolean hasTypeVariable(Type type) {
        GenericArrayType genericArrayType;
        if (JavaPropertyReflectionUtil.doesNotHaveTypeVariable(type)) {
            return false;
        }
        if (type instanceof TypeVariable) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            boolean noTypeVariables = true;
            for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
                if (actualTypeArgument instanceof TypeVariable) {
                    return true;
                }
                noTypeVariables &= JavaPropertyReflectionUtil.doesNotHaveTypeVariable(actualTypeArgument);
            }
            if (noTypeVariables) {
                return false;
            }
        }
        if (type instanceof GenericArrayType && (genericArrayType = (GenericArrayType)type).getGenericComponentType() instanceof TypeVariable) {
            return true;
        }
        ArrayDeque<Type> typesToInspect = new ArrayDeque<Type>();
        typesToInspect.add(type);
        while (!typesToInspect.isEmpty()) {
            Type typeToInspect = (Type)typesToInspect.remove();
            if (typeToInspect instanceof Class) continue;
            if (typeToInspect instanceof TypeVariable) {
                return true;
            }
            if (typeToInspect instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)typeToInspect;
                CollectionUtils.addAll(typesToInspect, (Object[])parameterizedType.getActualTypeArguments());
                continue;
            }
            if (typeToInspect instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)typeToInspect;
                typesToInspect.add(arrayType.getGenericComponentType());
                continue;
            }
            if (typeToInspect instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)typeToInspect;
                CollectionUtils.addAll(typesToInspect, (Object[])wildcardType.getLowerBounds());
                CollectionUtils.addAll(typesToInspect, (Object[])wildcardType.getUpperBounds());
                continue;
            }
            return true;
        }
        return false;
    }

    private static boolean doesNotHaveTypeVariable(Type type) {
        if (type instanceof Class) {
            return true;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            for (Type lowerBound : wildcardType.getLowerBounds()) {
                if (lowerBound instanceof Class) continue;
                return false;
            }
            for (Type upperBound : wildcardType.getUpperBounds()) {
                if (upperBound instanceof Class) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static class MethodBackedPropertyMutator
    implements PropertyMutator {
        private final String property;
        private final Method method;

        MethodBackedPropertyMutator(String property, Method method) {
            this.property = property;
            this.method = method;
        }

        public String toString() {
            return "property " + this.method.getDeclaringClass().getSimpleName() + "." + this.property;
        }

        @Override
        public String getName() {
            return this.property;
        }

        @Override
        public Class<?> getType() {
            return this.method.getParameterTypes()[0];
        }

        @Override
        public void setValue(Object target, Object value) {
            try {
                this.method.invoke(target, value);
            }
            catch (InvocationTargetException e) {
                throw UncheckedException.unwrapAndRethrow((InvocationTargetException)e);
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
    }

    private static class GetterMethodBackedPropertyAccessor<T, F>
    implements PropertyAccessor<T, F> {
        private final String property;
        private final Method method;
        private final Class<F> returnType;

        GetterMethodBackedPropertyAccessor(String property, Class<F> returnType, Method method) {
            this.property = property;
            this.method = method;
            this.returnType = returnType;
        }

        public String toString() {
            return "property " + this.method.getDeclaringClass().getSimpleName() + "." + this.property;
        }

        @Override
        public String getName() {
            return this.property;
        }

        @Override
        public Class<F> getType() {
            return this.returnType;
        }

        @Override
        public F getValue(T target) {
            try {
                return this.returnType.cast(this.method.invoke(target, new Object[0]));
            }
            catch (InvocationTargetException e) {
                throw UncheckedException.unwrapAndRethrow((InvocationTargetException)e);
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
    }
}

