/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Streams;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.gradle.internal.execution.BuildOutputCleanupRegistry;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.OutputFilesRepository;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.WorkspaceContext;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupStaleOutputsStep<C extends WorkspaceContext, R extends Result>
implements Step<C, R> {
    @VisibleForTesting
    public static final String CLEAN_STALE_OUTPUTS_DISPLAY_NAME = "Clean stale outputs";
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanupStaleOutputsStep.class);
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildOutputCleanupRegistry cleanupRegistry;
    private final Deleter deleter;
    private final OutputChangeListener outputChangeListener;
    private final OutputFilesRepository outputFilesRepository;
    private final Step<? super C, ? extends R> delegate;

    public CleanupStaleOutputsStep(BuildOperationExecutor buildOperationExecutor, BuildOutputCleanupRegistry cleanupRegistry, Deleter deleter, OutputChangeListener outputChangeListener, OutputFilesRepository outputFilesRepository, Step<? super C, ? extends R> delegate) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.cleanupRegistry = cleanupRegistry;
        this.deleter = deleter;
        this.outputChangeListener = outputChangeListener;
        this.outputFilesRepository = outputFilesRepository;
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        if (work.shouldCleanupStaleOutputs()) {
            this.cleanupStaleOutputs(work, context);
        }
        return this.delegate.execute(work, context);
    }

    private void cleanupStaleOutputs(UnitOfWork work, C context) {
        final HashSet filesToDelete = new HashSet();
        work.visitOutputs(((WorkspaceContext)context).getWorkspace(), new UnitOfWork.OutputVisitor(){

            @Override
            public void visitOutputProperty(String propertyName, TreeType type, UnitOfWork.OutputFileValueSupplier value) {
                Streams.stream((Iterable)value.getFiles()).filter(CleanupStaleOutputsStep.this.cleanupRegistry::isOutputOwnedByBuild).filter(file -> !CleanupStaleOutputsStep.this.outputFilesRepository.isGeneratedByGradle((File)file)).filter(file -> file.exists() || Files.isSymbolicLink(file.toPath())).forEach(filesToDelete::add);
            }
        });
        if (!filesToDelete.isEmpty()) {
            this.outputChangeListener.invalidateCachesFor(filesToDelete.stream().map(File::getAbsolutePath).collect(Collectors.toList()));
            this.buildOperationExecutor.run(new RunnableBuildOperation(){

                public void run(BuildOperationContext context) throws IOException {
                    for (File file : filesToDelete) {
                        LOGGER.info("Deleting stale output file: {}", (Object)file.getAbsolutePath());
                        CleanupStaleOutputsStep.this.deleter.deleteRecursively(file);
                    }
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)CleanupStaleOutputsStep.CLEAN_STALE_OUTPUTS_DISPLAY_NAME).progressDisplayName("Cleaning stale outputs");
                }
            });
        }
    }
}

