/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.component.ConfigurationVariantDetails;
import org.gradle.api.specs.Spec;

public class JavaConfigurationVariantMapping
implements Action<ConfigurationVariantDetails> {
    public static final Set<String> UNPUBLISHABLE_VARIANT_ARTIFACTS = ImmutableSet.of((Object)"java-classes-directory", (Object)"java-resources-directory", (Object)"directory");
    private final String scope;
    private final boolean optional;

    public JavaConfigurationVariantMapping(String scope, boolean optional) {
        this.scope = scope;
        this.optional = optional;
    }

    public void execute(ConfigurationVariantDetails details) {
        ConfigurationVariant variant = details.getConfigurationVariant();
        if (UnpublishableArtifactTypeSpec.INSTANCE.isSatisfiedBy(variant)) {
            details.skip();
        } else {
            details.mapToMavenScope(this.scope);
            if (this.optional) {
                details.mapToOptional();
            }
        }
    }

    private static class UnpublishableArtifactTypeSpec
    implements Spec<ConfigurationVariant> {
        private static final UnpublishableArtifactTypeSpec INSTANCE = new UnpublishableArtifactTypeSpec();

        private UnpublishableArtifactTypeSpec() {
        }

        public boolean isSatisfiedBy(ConfigurationVariant element) {
            for (PublishArtifact artifact : element.getArtifacts()) {
                if (!UNPUBLISHABLE_VARIANT_ARTIFACTS.contains(artifact.getType())) continue;
                return true;
            }
            return false;
        }
    }
}

