/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import net.i2p.router.transport.udp.OutboundMessageState;
import net.i2p.router.transport.udp.PeerState;

class PacketBuilder {
    static final int TYPE_FIRST = 42;
    static final int TYPE_ACK = 42;
    static final int TYPE_PUNCH = 43;
    static final int TYPE_RESP = 44;
    static final int TYPE_INTRO = 45;
    static final int TYPE_RREQ = 46;
    static final int TYPE_TCB = 47;
    static final int TYPE_TBC = 48;
    static final int TYPE_TTA = 49;
    static final int TYPE_TFA = 50;
    static final int TYPE_CONF = 51;
    static final int TYPE_SREQ = 52;
    static final int TYPE_CREAT = 53;
    public static final int HEADER_SIZE = 37;
    public static final int FRAGMENT_HEADER_SIZE = 7;
    public static final int DATA_HEADER_SIZE = 46;
    public static final int IP_HEADER_SIZE = 20;
    public static final int UDP_HEADER_SIZE = 8;
    public static final int MIN_DATA_PACKET_OVERHEAD = 74;
    public static final int IPV6_HEADER_SIZE = 40;
    public static final int MIN_IPV6_DATA_PACKET_OVERHEAD = 94;
    public static final int ABSOLUTE_MAX_ACKS = 255;
    private static final int MAX_RESEND_ACKS_LARGE = 9;
    private static final int MAX_RESEND_ACKS_SMALL = 4;
    private static final String PROP_PADDING = "i2np.udp.padding";
    private static final boolean DEFAULT_ENABLE_PADDING = true;
    private static final byte SESSION_REQUEST_FLAG_BYTE = 0;
    private static final byte SESSION_CREATED_FLAG_BYTE = 16;
    private static final byte SESSION_CONFIRMED_FLAG_BYTE = 32;
    private static final byte PEER_RELAY_REQUEST_FLAG_BYTE = 48;
    private static final byte PEER_RELAY_RESPONSE_FLAG_BYTE = 64;
    private static final byte PEER_RELAY_INTRO_FLAG_BYTE = 80;
    private static final byte DATA_FLAG_BYTE = 96;
    private static final byte PEER_TEST_FLAG_BYTE = 112;
    private static final byte SESSION_DESTROY_FLAG_BYTE = -128;
    static final int PRIORITY_HIGH = 550;
    private static final int PRIORITY_LOW = 100;

    PacketBuilder() {
    }

    public static int getMaxAdditionalFragmentSize(PeerState peer, int numFragments, int curDataSize) {
        int available = peer.getMTU() - curDataSize;
        available = peer.isIPv6() ? (available -= 94) : (available -= 74);
        return available -= numFragments * 7;
    }

    public static class Fragment {
        public final OutboundMessageState state;
        public final int num;

        public Fragment(OutboundMessageState state, int num) {
            this.state = state;
            this.num = num;
        }

        public String toString() {
            return "Fragment " + this.num + " (" + this.state.fragmentSize(this.num) + " bytes) of " + this.state;
        }
    }
}

