/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.event;

import org.cybergarage.http.HTTPResponse;
import org.cybergarage.upnp.UPnP;
import org.cybergarage.upnp.event.Subscription;

public class SubscriptionResponse
extends HTTPResponse {
    public SubscriptionResponse() {
        this.setServer(UPnP.getServerName());
    }

    public SubscriptionResponse(HTTPResponse httpRes) {
        super(httpRes);
    }

    public void setResponse(int code) {
        this.setStatusCode(code);
        this.setContentLength(0L);
    }

    public void setErrorResponse(int code) {
        this.setStatusCode(code);
        this.setContentLength(0L);
    }

    public void setSID(String id) {
        this.setHeader("SID", Subscription.toSIDHeaderString(id));
    }

    public String getSID() {
        return Subscription.getSID(this.getHeaderValue("SID"));
    }

    public void setTimeout(long value) {
        this.setHeader("TIMEOUT", Subscription.toTimeoutHeaderString(value));
    }

    public long getTimeout() {
        return Subscription.getTimeout(this.getHeaderValue("TIMEOUT"));
    }
}

